/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ColoredTable
extends JTable {
    public ColoredTable(TableModel tableModel, TableColumnModel columnModel) {
        super(tableModel, columnModel);
        this.setOpaque(false);
        this.setShowGrid(true);
        this.setGridColor(this.getGridColor().brighter());
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(1);
        this.setSelectionBackground(new Color(15132410));
        this.setDefaultRenderer(Object.class, new SelectionPaintingCellRenderer());
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.addViewportHeight(super.getMinimumSize());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.addViewportHeight(super.getPreferredSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Color oddLineColor = this.oddLineColor();
        Color evenLineColor = this.evenLineColor();
        Color originalColor = g.getColor();
        try {
            Rectangle clipBounds = g.getClipBounds();
            int rh = this.getRowHeight();
            int i = clipBounds.y / rh;
            int w = this.getWidth();
            int h = clipBounds.y + clipBounds.height;
            for (int y = clipBounds.y / rh * rh; y < h; y += rh) {
                g.setColor(i % 2 == 1 ? oddLineColor : evenLineColor);
                g.fillRect(0, y, w, rh);
                ++i;
            }
        }
        finally {
            g.setColor(originalColor);
        }
        this.paintGrid(g);
        super.paintComponent(g);
    }

    private void paintGrid(Graphics g) {
        g.setColor(this.getGridColor());
        if (this.getShowHorizontalLines()) {
            Rectangle clipBounds = g.getClipBounds();
            int rh = this.getRowHeight();
            int w = this.getWidth();
            int h = clipBounds.y + clipBounds.height;
            for (int y = clipBounds.y > 0 ? clipBounds.y / rh * rh : rh; y <= h; y += rh) {
                g.drawLine(clipBounds.x, y - 1, w - 1, y - 1);
            }
        }
    }

    public Color oddLineColor() {
        Color backgroundColor = this.getBackground();
        Color oddLineColor = new Color(250 * backgroundColor.getRed() / 256, 250 * backgroundColor.getGreen() / 256, 250 * backgroundColor.getBlue() / 256);
        return oddLineColor;
    }

    public Color evenLineColor() {
        return this.getBackground();
    }

    private Dimension addViewportHeight(Dimension result) {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            result.height = Math.max(viewport.getHeight(), result.height);
        }
        return result;
    }

    class SelectionPaintingCellRenderer
    extends DefaultTableCellRenderer {
        SelectionPaintingCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(table.getForeground());
            this.setOpaque(isSelected);
            return this;
        }
    }
}

