/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceDrivenLayout
implements LayoutManager2 {
    GridBagLayout gridBagLayout = new GridBagLayout();
    Map<String, GridBagConstraints> map = new HashMap<String, GridBagConstraints>();

    public ResourceDrivenLayout(String template) {
        this.parse(template);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        String name;
        if (constraints != null) {
            if (!(constraints instanceof String)) throw new IllegalArgumentException(String.valueOf(constraints));
            name = constraints.toString();
        } else {
            name = comp.getName();
            if (name == null) {
                throw new IllegalArgumentException("Unnamed component");
            }
        }
        GridBagConstraints contraint = this.map.get(name);
        if (contraint == null) {
            throw new IllegalArgumentException("Uknown component '" + name + "'");
        }
        this.gridBagLayout.addLayoutComponent(comp, contraint);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return this.gridBagLayout.getLayoutAlignmentX(target);
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return this.gridBagLayout.getLayoutAlignmentY(target);
    }

    @Override
    public void invalidateLayout(Container target) {
        this.gridBagLayout.invalidateLayout(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.gridBagLayout.maximumLayoutSize(target);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void layoutContainer(Container parent) {
        this.gridBagLayout.layoutContainer(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.gridBagLayout.minimumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.gridBagLayout.preferredLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.gridBagLayout.removeLayoutComponent(comp);
    }

    private void parse(String resource) {
        CharacterScreen template = new CharacterScreen(resource);
        GridCoordinates grid = new GridCoordinates(resource);
        for (int x = 0; x < template.width(); ++x) {
            for (int y = 0; y < template.height(); ++y) {
                int height;
                int width;
                String string;
                if (!template.isTopLeftCorner(x, y) || (string = template.textAt(x, y, width = template.lenghtAt(x, y), height = template.heightAt(x, y))).trim().length() <= 0) continue;
                int gridX = grid.gridX(x);
                int gridY = grid.gridY(y);
                int gridW = grid.gridX(x + width - 1) - gridX + 1;
                int gridH = grid.gridY(y + height - 1) - gridY + 1;
                Text text = new Text(string);
                this.map.put(text.getComponentName(), new GridBagConstraints(gridX, gridY, gridW, gridH, text.getWeightX(), text.getWeightY(), text.getAnchor(), text.getFill(), text.getInsets(), text.getIpadX(), text.getIpadY()));
            }
        }
    }

    static class Text {
        private String componentName;
        private String fill;
        private String anchor;
        private String topInset;
        private String leftInset;
        private String bottomInset;
        private String rightInset;
        private String weightX;
        private String weightY;
        private String ipadX;
        private String ipadY;
        private static Pattern pattern = Pattern.compile("\\s*(\\S+)(\\s+(NONE|BOTH|HORIZONTAL|VERTICAL))?(\\s+(CENTER|NORTH|NORTHEAST|EAST|SOUTHEAST|SOUTH|SOUTHWEST|WEST|NORTHWEST))?(\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+))?(\\s+(\\-?\\d{1,3})%(\\s+(\\-?\\d{1,3})%)?)?(\\s+(\\d+)\\s+(\\d+))?\\s*");

        Text(String text) {
            Matcher matcher = pattern.matcher(text);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(text);
            }
            this.componentName = matcher.group(1);
            this.fill = matcher.group(3);
            this.anchor = matcher.group(5);
            this.topInset = matcher.group(7);
            this.leftInset = matcher.group(8);
            this.bottomInset = matcher.group(9);
            this.rightInset = matcher.group(10);
            this.weightX = matcher.group(12);
            this.weightY = matcher.group(14);
            this.ipadX = matcher.group(16);
            this.ipadY = matcher.group(17);
        }

        String getComponentName() {
            return this.componentName;
        }

        int getFill() {
            return this.constant(this.fill, 0);
        }

        int getAnchor() {
            return this.constant(this.anchor, 10);
        }

        Insets getInsets() {
            if (this.topInset != null) {
                return new Insets(Integer.parseInt(this.topInset), Integer.parseInt(this.leftInset), Integer.parseInt(this.bottomInset), Integer.parseInt(this.rightInset));
            }
            return new Insets(0, 0, 0, 0);
        }

        double getWeightX() {
            return this.percent(this.weightX);
        }

        double getWeightY() {
            return this.percent(this.weightY);
        }

        int getIpadX() {
            return this.integer(this.ipadX);
        }

        int getIpadY() {
            return this.integer(this.ipadY);
        }

        private double percent(String value) {
            if (value != null) {
                return (double)Integer.parseInt(value) / 100.0;
            }
            return 0.0;
        }

        private int integer(String value) {
            if (value != null) {
                return Integer.parseInt(value);
            }
            return 0;
        }

        private int constant(String name, int defaultValue) {
            try {
                if (name != null) {
                    return (Integer)GridBagConstraints.class.getField(name).get(null);
                }
                return defaultValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class GridCoordinates {
        List<Integer> xcoords;
        List<Integer> ycoords;

        GridCoordinates(String resource) {
            String[] lines = resource.split("\n");
            TreeSet<Integer> xSet = new TreeSet<Integer>();
            TreeSet<Integer> ySet = new TreeSet<Integer>();
            for (int y = 0; y < lines.length; ++y) {
                block6: for (int x = 0; x < lines[0].length(); ++x) {
                    switch (lines[y].charAt(x)) {
                        case '|': {
                            xSet.add(x);
                            continue block6;
                        }
                        case '-': {
                            ySet.add(y);
                            continue block6;
                        }
                        case '\t': {
                            throw new IllegalStateException("Tab at line " + y + " column " + x + ":" + lines[y]);
                        }
                    }
                }
            }
            this.xcoords = new ArrayList<Integer>(xSet);
            this.ycoords = new ArrayList<Integer>(ySet);
        }

        int gridX(int column) {
            return this.indexOf(this.xcoords, column);
        }

        int gridY(int row) {
            return this.indexOf(this.ycoords, row);
        }

        private int indexOf(List<Integer> coords, int coord) {
            for (int i = 1; i < coords.size(); ++i) {
                if (coords.get(i) <= coord) continue;
                return i - 1;
            }
            throw new IllegalArgumentException(String.valueOf(coord));
        }
    }

    static class CharacterScreen {
        String[] lines;

        CharacterScreen(String resource) {
            this.lines = resource.split("\n");
            if (this.lines.length == 0) {
                throw new IllegalArgumentException(resource);
            }
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i].length() == this.lines[0].length()) continue;
                throw new IllegalArgumentException("line " + i + ":" + this.lines[i]);
            }
        }

        boolean isTopLeftCorner(int column, int row) {
            if (row > 0 && column > 0) {
                return this.lines[row - 1].charAt(column - 1) == '+' && this.lines[row - 1].charAt(column) == '-' && this.lines[row].charAt(column - 1) == '|';
            }
            return false;
        }

        int lenghtAt(int column, int row) {
            int result = 1;
            while (column + result < this.lines[row].length() && this.lines[row].charAt(column + result) != '|') {
                ++result;
            }
            return result;
        }

        int heightAt(int column, int row) {
            int result = 1;
            while (row + result < this.lines.length && this.lines[row + result].charAt(column) != '-') {
                ++result;
            }
            return result;
        }

        String textAt(int column, int row, int length, int height) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < height; ++j) {
                stringBuilder.append(this.lines[row + j].substring(column, column + length));
            }
            return stringBuilder.toString();
        }

        int width() {
            return this.lines[0].length();
        }

        int height() {
            return this.lines.length;
        }
    }
}

