/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.IHeaderBar;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.help.ui.HelpInitializer;
import com.selima.help.ui.HelpInitializerSingleton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicButtonUI;

public class HeaderBar
extends JPanel
implements IHeaderBar {
    JLabel headerLabel;

    public HeaderBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.headerLabel = new JLabel();
        this.headerLabel.setForeground(Color.WHITE);
        this.headerLabel.setFont(this.headerLabel.getFont().deriveFont(1));
        this.add(this.headerLabel);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(2, 5, 1, 2)));
        this.setBackground(new Color(9143922));
        this.add(Box.createHorizontalGlue());
        JButton mainHelpButton = new JButton(new DisplayMainHelpAction());
        mainHelpButton.setUI(new BasicButtonUI());
        mainHelpButton.setIcon(SwingHelper.imageIcon("/img/16x16/changed/main-help.png"));
        mainHelpButton.setOpaque(false);
        mainHelpButton.setRolloverEnabled(true);
        mainHelpButton.setRolloverIcon(SwingHelper.imageIcon("/img/16x16/changed/main-help.roll.png"));
        mainHelpButton.setPreferredSize(new Dimension(18, 20));
        mainHelpButton.setFocusable(false);
        JButton contextHelpButton = new JButton(new InitiateContextHelpAction());
        contextHelpButton.setUI(new BasicButtonUI());
        contextHelpButton.setIcon(SwingHelper.imageIcon("/img/16x16/changed/context-help.png"));
        contextHelpButton.setOpaque(false);
        contextHelpButton.setRolloverEnabled(true);
        contextHelpButton.setRolloverIcon(SwingHelper.imageIcon("/img/16x16/changed/context-help.roll.png"));
        contextHelpButton.setPreferredSize(new Dimension(18, 20));
        contextHelpButton.setFocusable(false);
        this.add(contextHelpButton);
        this.add(mainHelpButton);
    }

    @Override
    public void clear() {
        this.headerLabel.setText(null);
        this.headerLabel.setIcon(null);
    }

    @Override
    public void displayContent(ClientContent cc) {
        this.headerLabel.setText(cc.getContentName());
        Image image = cc.getIcon().getImage().getScaledInstance(16, 16, 4);
        this.headerLabel.setIcon(new ImageIcon(image));
    }

    private Border createRollOverBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new BorderUIResource.CompoundBorderUIResource(new BasicBorders.RolloverButtonBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight")), new BasicBorders.MarginBorder());
    }

    class InitiateContextHelpAction
    extends AbstractHelpAction {
        ActionListener cshListener;

        InitiateContextHelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.cshListener == null) {
                HelpSet hs = HelpInitializerSingleton.getInstance().getHelpBroker().getHelpSet();
                this.cshListener = new CSH.DisplayHelpAfterTracking(hs, "javax.help.SecondaryWindow", "Popup");
            }
            this.cshListener.actionPerformed(evt);
        }
    }

    class DisplayMainHelpAction
    extends AbstractHelpAction {
        HelpBroker hb;

        DisplayMainHelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.hb == null) {
                HelpInitializer hi = HelpInitializerSingleton.getInstance();
                this.hb = hi.getHelpBroker().getHelpSet().createHelpBroker();
            }
            this.hb.showID("content.index", "javax.help.MainWindow", "Main");
        }
    }

    abstract class AbstractHelpAction
    extends AbstractAction
    implements HelpInitializer.HelpLoadedCallBack {
        AbstractHelpAction() {
            this.setEnabled(false);
            HelpInitializer hi = HelpInitializerSingleton.getInstance();
            if (hi != null) {
                hi.insertHelp((HelpInitializer.HelpLoadedCallBack)this);
            }
        }

        public void helpLoaded(HelpBroker hb) {
            this.setEnabled(true);
        }

        public void helpFailed(Exception e) {
            System.out.println("helpFailed:" + e);
        }
    }
}

