/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.typed;

import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.core.payebeans.IResetListener;
import com.selima.fbi.typed.Accessor;
import com.selima.fbi.typed.Formatter;
import com.selima.fbi.typed.TypedProperty;
import com.selima.framework.util.logging.LogAPI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractTypedProperty<PropertyType>
implements TypedProperty,
IResetListener,
PropertyChangeListener {
    private boolean hasValue;
    private PropertyType value;
    private Class<PropertyType> propertyType;
    private final Formatter<PropertyType> formatter;
    private final Accessor<IBeanMessage, PropertyType> accessor;

    AbstractTypedProperty(Class<PropertyType> propertyType, Formatter<PropertyType> formatter, Accessor<IBeanMessage, PropertyType> accessor) {
        this.accessor = accessor;
        this.formatter = formatter;
        this.propertyType = propertyType;
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public void reseted() {
        this.hasValue = false;
    }

    @Override
    public void observe(IBeanMessage message) {
        if (this.hasValue) {
            this.accessor.set(message, this.value);
        }
        this.accessor.addResetListener(message, this);
        this.accessor.addPropertyChangeListener(message, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.value = this.propertyType.cast(evt.getNewValue());
        this.hasValue = true;
    }

    @Override
    public void setTextValue(String string) {
        try {
            this.value = this.formatter.parse(string);
            this.hasValue = true;
        }
        catch (NumberFormatException e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    @Override
    public String getTextValue() {
        return this.formatter.format(this.value);
    }
}

