/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.fbi.threading.GWModel;
import com.selima.fbi.threading.GWModelEvent;
import com.selima.fbi.threading.GWModelListener;
import com.selima.fbi.threading.GWThreadFactory;
import com.selima.fbi.threading.IGWImageSupply;
import com.selima.fbi.threading.IGWImageSupplyContext;
import com.selima.framework.threading.BackendWorkEventListener;
import com.selima.framework.threading.BackendWorkEventSource;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class GWPanel
extends JPanel
implements GWModelListener,
IGWImageSupplyContext {
    public static final int REFRESH_TIME = 30;
    public static final String NAME = "GWPanel";
    private IGWImageSupply imageSupply;
    private GWModel model;
    private Timer timer;
    private boolean prefSizeSet;
    private BackendWorkEventSource eventSource;

    public GWPanel(IGWImageSupply imageSupply) {
        this(imageSupply, GWThreadFactory.getGWInstance(), 30);
    }

    public GWPanel(IGWImageSupply imageSupply, int refreshTime) {
        this(imageSupply, GWThreadFactory.getGWInstance(), refreshTime);
    }

    public GWPanel(IGWImageSupply imageSupply, BackendWorkEventSource eventSource, int refreshTime) {
        this.setName(NAME);
        this.imageSupply = imageSupply;
        this.eventSource = eventSource;
        imageSupply.setContext(this);
        this.timer = new Timer(refreshTime, new TimerListener());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(new GWModel());
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.prefSizeSet = true;
        super.setPreferredSize(preferredSize);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets;
        Dimension result = null;
        if (!this.prefSizeSet && (result = this.imageSupply.suggestPreferredSize()) != null && (insets = this.getInsets()) != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        return result == null ? super.getPreferredSize() : result;
    }

    @Override
    public void started(GWModelEvent event) {
        this.timer.start();
    }

    @Override
    public void stopped(GWModelEvent event) {
        this.timer.stop();
        this.imageSupply.reset();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.imageSupply.paintImage(g);
    }

    public GWModel getModel() {
        return this.model;
    }

    public void detach() {
        this.eventSource.removeBackendWorkEventListener((BackendWorkEventListener)this.model);
        this.stopped(null);
    }

    private void setModel(GWModel model) {
        this.model = model;
        model.addGWModelListener(this);
        this.eventSource.addBackendWorkEventListener((BackendWorkEventListener)model);
    }

    @Override
    public String getToolTipText() {
        List<String> ids = this.model.getRunningIds();
        if (!ids.isEmpty()) {
            StringBuilder result = new StringBuilder("<html><ul style='margin: 15px'>");
            for (String name : ids) {
                result.append("<li>").append(name).append("</li>");
            }
            result.append("</ul></html>");
            return result.toString();
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public boolean isPrefSize() {
        return this.prefSizeSet;
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GWPanel.this.imageSupply.switchImage();
            GWPanel.this.paintImmediately(0, 0, GWPanel.this.getWidth(), GWPanel.this.getHeight());
        }
    }
}

