/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.fbi.threading.GWAbstractImageSupply;
import com.selima.fbi.threading.IGWImageSupply;
import com.selima.fbi.threading.IGWImageSupplyContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageObserver;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class GWImageSupplyFactory {
    public static IGWImageSupply createMultiImageSupply(String[] imagePaths) {
        return new MultiImageSupply(imagePaths);
    }

    public static IGWImageSupply createMovingImageSupply(String imagePath) {
        return new MovingImageSupply(imagePath);
    }

    public static IGWImageSupply createMovingImageSupply(String imagePath, int step, boolean repeat) {
        return new MovingImageSupply(imagePath, step, repeat, true);
    }

    public static IGWImageSupply createMovingImageSupply(String imagePath, int step, boolean repeat, boolean addCrop) {
        return new MovingImageSupply(imagePath, step, repeat, addCrop);
    }

    public static IGWImageSupply createPaintedBackgroundSupply(Color topColor, Color bottomColor) {
        return new PaintedBackgroundSupply(topColor, bottomColor);
    }

    public static IGWImageSupply createPaintedBackgroundSupply() {
        return new PaintedBackgroundSupply();
    }

    public static CompoundImageSupply createCompoundImageSupply() {
        return new CompoundImageSupply();
    }

    public static IGWImageSupply createCompoundImageSupply(IGWImageSupply supply1, IGWImageSupply supply2) {
        return new CompoundImageSupply(supply1, supply2);
    }

    public static IGWImageSupply createCompoundImageSupply(IGWImageSupply supply1, IGWImageSupply supply2, IGWImageSupply supply3) {
        CompoundImageSupply supply = new CompoundImageSupply();
        supply.addImageSupply(supply1);
        supply.addImageSupply(supply2);
        supply.addImageSupply(supply3);
        return supply;
    }

    public static class PaintedBackgroundSupply
    extends GWAbstractImageSupply {
        public static final Color TOP_COLOR = new Color(235, 235, 235);
        public static final Color BOTTOM_COLOR = new Color(96, 32, 32);
        private Color topColor;
        private Color bottomColor;
        int topcenter;
        int step = 2;
        boolean increase = true;

        public PaintedBackgroundSupply() {
            this(TOP_COLOR, BOTTOM_COLOR);
        }

        public PaintedBackgroundSupply(Color topColor, Color bottomColor) {
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        @Override
        public void switchImage() {
            if (this.increase) {
                this.topcenter += this.step;
                if (this.topcenter + this.step > 100) {
                    this.increase = false;
                }
            } else {
                this.topcenter -= this.step;
                if (this.topcenter - this.step < 0) {
                    this.increase = true;
                }
            }
        }

        @Override
        public void reset() {
        }

        @Override
        public void paintImage(Graphics g) {
            Insets insets = this.context.getComponent().getInsets();
            Dimension dim = this.context.getComponent().getSize();
            dim.width -= insets.left + insets.right;
            dim.height -= insets.top + insets.bottom;
            int redrange = this.bottomColor.getRed() - this.topColor.getRed();
            int greenrange = this.bottomColor.getGreen() - this.topColor.getGreen();
            int bluerange = this.bottomColor.getBlue() - this.topColor.getBlue();
            int center = this.topcenter * dim.height / 100;
            for (int y = 0; y < dim.height; ++y) {
                int offset = Math.abs(y - center);
                Color rc = new Color(offset * redrange / dim.height + this.topColor.getRed(), offset * greenrange / dim.height + this.topColor.getGreen(), offset * bluerange / dim.height + this.topColor.getRed());
                g.setColor(rc);
                g.drawLine(insets.left, y + insets.top, insets.left + dim.width, y + insets.top);
            }
        }

        @Override
        public Dimension suggestPreferredSize() {
            return null;
        }
    }

    public static class MovingImageSupply
    extends ComponentAdapter
    implements IGWImageSupply,
    ImageObserver {
        private int step;
        private boolean repeat;
        private boolean addCrop;
        private IGWImageSupplyContext context;
        private volatile int imwidth;
        private volatile int imheight;
        private int width;
        private int offset;
        private Image image;

        public MovingImageSupply(String imagePath) {
            this(imagePath, 1, false, true);
        }

        public MovingImageSupply(String imagePath, int step, boolean repeat, boolean addCrop) {
            this(Toolkit.getDefaultToolkit().createImage(MovingImageSupply.class.getResource(imagePath)), step, repeat, addCrop);
        }

        public MovingImageSupply(Image image) {
            this(image, 1, false, true);
        }

        public MovingImageSupply(Image image, int step, boolean repeat, boolean addCrop) {
            int h;
            this.step = step;
            this.repeat = repeat;
            this.addCrop = addCrop;
            this.image = image;
            int w = image.getWidth(this);
            if (w != -1) {
                this.imwidth = w;
            }
            if ((h = image.getHeight(this)) != -1) {
                this.imheight = h;
            }
            this.computeWidth();
        }

        @Override
        public void switchImage() {
            if (this.width > 0) {
                this.offset = (this.offset + this.step) % this.width;
                if (this.offset < 0) {
                    this.offset += this.width;
                }
            }
        }

        @Override
        public void paintImage(Graphics g) {
            if (this.imwidth <= 0 || this.imheight <= 0) {
                return;
            }
            Insets insets = this.context.getComponent().getInsets();
            Dimension dim = this.context.getComponent().getSize();
            Graphics graph = g.create(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
            int left = this.offset;
            if (this.addCrop) {
                graph.drawImage(this.image, left - this.width, 0, null);
            }
            graph.drawImage(this.image, left, 0, null);
            if (this.repeat) {
                left += this.width;
                int max = this.context.getComponent().getSize().width - insets.right;
                while (left < max) {
                    graph.drawImage(this.image, left, 0, null);
                    left += this.width;
                }
            }
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 3) != 0) {
                Container container;
                this.imwidth = img.getWidth(null);
                this.imheight = img.getHeight(null);
                this.computeWidth();
                if (this.context != null && this.imwidth != -1 && this.imheight != -1 && (container = this.context.getComponent().getParent()) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            container.invalidate();
                            context.getComponent().repaint();
                        }
                    });
                }
            }
            return true;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            this.computeWidth();
        }

        @Override
        public void reset() {
            this.offset = this.step > 0 ? 0 : this.width - 1;
        }

        @Override
        public void setContext(IGWImageSupplyContext context) {
            this.context = context;
            context.getComponent().addComponentListener(this);
        }

        @Override
        public synchronized Dimension suggestPreferredSize() {
            return new Dimension(this.imwidth, this.imheight);
        }

        private void computeWidth() {
            if (this.imwidth != 0 && this.context != null) {
                Insets insets = this.context.getComponent().getInsets();
                Dimension dim = this.context.getComponent().getSize();
                int height = dim.height - insets.top - insets.bottom;
                this.width = Math.max(1, Math.min(2 * this.imwidth * height / this.imheight, this.imwidth));
            } else {
                this.width = this.imwidth;
            }
            if (this.width > 0 && this.step < 0 && this.offset == 0) {
                this.offset = this.width - 1;
            }
        }
    }

    public static class MultiImageSupply
    extends GWAbstractImageSupply
    implements ImageObserver {
        private Image[] images;
        private int imageIndex;

        public MultiImageSupply(String[] imagePaths) {
            this.images = new Image[imagePaths.length];
            for (int i = 0; i < imagePaths.length; ++i) {
                this.images[i] = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(imagePaths[i]));
                this.images[i].getWidth(null);
                this.images[i].getHeight(null);
            }
            this.images[0].getWidth(this);
            this.images[0].getHeight(this);
        }

        @Override
        public void switchImage() {
            ++this.imageIndex;
            this.imageIndex %= this.images.length;
        }

        @Override
        public void paintImage(Graphics g) {
            Insets insets = this.context.getComponent().getInsets();
            g.drawImage(this.images[this.imageIndex], insets.left, insets.right, null);
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            Container container;
            if (this.context != null && (infoflags & 3) != 0 && (container = this.context.getComponent().getParent()) != null && img.getWidth(null) != -1 && img.getHeight(null) != -1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        container.invalidate();
                        context.getComponent().repaint();
                    }
                });
            }
            return true;
        }

        @Override
        public void reset() {
        }

        @Override
        public Dimension suggestPreferredSize() {
            return new Dimension(this.images[0].getWidth(null), this.images[0].getHeight(null));
        }
    }

    public static class CompoundImageSupply
    implements IGWImageSupply {
        private List<IGWImageSupply> supplies = new LinkedList<IGWImageSupply>();

        public CompoundImageSupply() {
        }

        public CompoundImageSupply(IGWImageSupply supply1, IGWImageSupply supply2) {
            this.addImageSupply(supply1);
            this.addImageSupply(supply2);
        }

        public void addImageSupply(IGWImageSupply supply) {
            if (supply != null) {
                this.supplies.add(supply);
            }
        }

        @Override
        public void setContext(IGWImageSupplyContext context) {
            Iterator<IGWImageSupply> iterator = this.supplies.iterator();
            while (iterator.hasNext()) {
                iterator.next().setContext(context);
            }
        }

        @Override
        public void switchImage() {
            Iterator<IGWImageSupply> iterator = this.supplies.iterator();
            while (iterator.hasNext()) {
                iterator.next().switchImage();
            }
        }

        @Override
        public void paintImage(Graphics g) {
            Iterator<IGWImageSupply> iterator = this.supplies.iterator();
            while (iterator.hasNext()) {
                iterator.next().paintImage(g);
            }
        }

        @Override
        public void reset() {
            Iterator<IGWImageSupply> iterator = this.supplies.iterator();
            while (iterator.hasNext()) {
                iterator.next().reset();
            }
        }

        @Override
        public Dimension suggestPreferredSize() {
            Dimension result = null;
            Iterator<IGWImageSupply> it = this.supplies.iterator();
            while (it.hasNext() && (result = it.next().suggestPreferredSize()) == null) {
            }
            return result;
        }
    }
}

