/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.sender;

import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.hmrcMark.HMRCMarkException;
import com.selima.fbi.submission.GovTalkResponse;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IMessageDetails;
import com.selima.fbi.submission.core.MutableGovTalkMessage;
import com.selima.fbi.submission.core.MutableMessageDetails;
import com.selima.fbi.submission.core.body.IStatusReportRange;
import com.selima.fbi.submission.core.body.MutableStatusReport;
import com.selima.fbi.submission.loader.GovTalkMessageLoader;
import com.selima.fbi.submission.loader.StatusReportLoader;
import com.selima.fbi.submission.loader.StatusReportRangeLoader;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestSender
implements IGovTalkMessageSender {
    private static final String DEFAULT_URL = "http://selima.uk/submission";
    private int stepCounter = 0;
    private GovTalkMessageLoader loader = new GovTalkMessageLoader();
    private String correlationID;
    private Document irMarkReceipt;
    private int delay;

    public TestSender(int delay) {
        this.reset();
    }

    public TestSender() {
        this(2);
    }

    @Override
    public IGovTalkMessage send(IGovTalkMessage message) throws IOException, SAXException {
        return this.send(message, DEFAULT_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGovTalkMessage send(IGovTalkMessage message, String urlStr) throws IOException, SAXException {
        int type = -1;
        IMessageDetails details = message.getHeader().getMessageDetails();
        String qualifier = details.getQualifier();
        String function = details.getFunction();
        if ("request".equals(qualifier) && "submit".equals(function)) {
            type = 1;
        }
        if ("poll".equals(qualifier) && "submit".equals(function)) {
            type = 2;
        }
        if ("request".equals(qualifier) && "list".equals(function)) {
            type = 3;
        }
        if ("request".equals(qualifier) && "delete".equals(function)) {
            type = 4;
        }
        if (type == 3) {
            try {
                MutableGovTalkMessage msg = null;
                GovTalkMessageLoader loader = new GovTalkMessageLoader();
                IStatusReportRange range = new StatusReportRangeLoader().load("<range>" + message.getBody() + "</range>");
                msg = (MutableGovTalkMessage)loader.load(this.getDataInputStream("govtalkmsg-data-response.xml"), true);
                MutableStatusReport report = (MutableStatusReport)new StatusReportLoader().load(msg.getBody());
                report.setSenderID(message.getHeader().getSenderDetails().getIDAuthentication().getSenderID());
                report.setStartTimeStamp(range.getStartDate() + " " + range.getStartTime());
                report.setEndTimeStamp(range.getEndDate() + " " + range.getEndTime());
                msg.setBody(report.toXML());
                MutableGovTalkMessage mutableGovTalkMessage = msg;
                return mutableGovTalkMessage;
            }
            finally {
                this.reset();
            }
        }
        if (this.stepCounter == 0 && type == 1) {
            ++this.stepCounter;
            if (HMRCMark.hmrcMarkFrom(message.getXMLStream()) != null) {
                try {
                    this.irMarkReceipt = HMRCMark.prepareIRmarkReceipt(message.getXMLStream());
                }
                catch (HMRCMarkException e) {
                    throw new IOException(e);
                }
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-submission-acknowledgement.xml"), false));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://submission2");
            return response.getGovTalkMessage();
        }
        if ((this.stepCounter == 1 || this.stepCounter == 0) && type == 2) {
            if (this.stepCounter == 0) {
                ++this.stepCounter;
                this.correlationID = message.getHeader().getMessageDetails().getCorrelationID();
            } else if (!"http://submission2".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            ++this.stepCounter;
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-submission-acknowledgement.xml"), false));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://submission3");
            return response.getGovTalkMessage();
        }
        if (this.stepCounter == 2 && type == 2) {
            ++this.stepCounter;
            if (!"http://submission3".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-submission-response.xml"), true));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://delete");
            if (this.irMarkReceipt != null) {
                try {
                    String body = response.getGovTalkMessage().getBody();
                    body = HMRCMark.addIRmarkReceipt(this.irMarkReceipt, body);
                    ((MutableGovTalkMessage)response.getGovTalkMessage()).setBody(body);
                }
                finally {
                    this.irMarkReceipt = null;
                }
            }
            return response.getGovTalkMessage();
        }
        if (this.stepCounter == 3 && type == 4) {
            ++this.stepCounter;
            if (!"http://delete".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-delete-acknowledgement.xml"), false));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://delete2");
            return response.getGovTalkMessage();
        }
        if (this.stepCounter == 4 && type == 4) {
            ++this.stepCounter;
            if (!"http://delete2".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-delete-acknowledgement.xml"), false));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://delete3");
            return response.getGovTalkMessage();
        }
        if (this.stepCounter == 5 && type == 4) {
            ++this.stepCounter;
            if (!"http://delete3".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-delete-acknowledgement.xml"), false));
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setCorrelationID(this.correlationID);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setPollInterval(this.delay);
            ((MutableMessageDetails)response.getGovTalkMessage().getHeader().getMessageDetails()).setResponseEndPoint("http://delete4");
            return response.getGovTalkMessage();
        }
        if (this.stepCounter == 6 && type == 4) {
            ++this.stepCounter;
            if (!"http://delete4".equals(urlStr)) {
                throw new IllegalArgumentException("Invalid submission url: " + urlStr);
            }
            String id = message.getHeader().getMessageDetails().getCorrelationID();
            if (!this.correlationID.equals(id)) {
                throw new IllegalArgumentException("Invalid correlation ID: " + id);
            }
            GovTalkResponse response = new GovTalkResponse(this.loader.load(this.getDataInputStream("govtalkmsg-delete-response.xml"), false));
            this.reset();
            return response.getGovTalkMessage();
        }
        this.reset();
        throw new IllegalArgumentException("Unexpected type of incoming message: " + type);
    }

    private void reset() {
        this.stepCounter = 0;
        this.correlationID = this.produceCorrelationId();
    }

    String produceCorrelationId() {
        long value = System.currentTimeMillis();
        StringBuilder result = new StringBuilder();
        do {
            long rem = value % Integer.MAX_VALUE;
            result.append(Integer.toString((int)rem, 36));
        } while ((value /= Integer.MAX_VALUE) > 0L);
        return result.toString().toUpperCase();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    public void setDefaultUrl(String url) {
    }

    private InputStream getDataInputStream(String resource) {
        return TestSender.class.getClassLoader().getResourceAsStream("com/selima/fbi/submission/sender/" + resource);
    }
}

