/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.sender;

import com.selima.fbi.submission.SubmitException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlSubmitException
extends SubmitException {
    String html;

    HtmlSubmitException(Throwable cause, String html) {
        super(cause, HtmlSubmitException.titleOf(html));
        if (html.startsWith("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">")) {
            html = html.substring("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">".length()).trim();
        }
        this.html = html;
    }

    private static String titleOf(String html) {
        Pattern pattern = Pattern.compile("<title>(.+)</title>|<h\\d[^>]*>(.+)</h\\d>", 10);
        Matcher matcher = pattern.matcher(html);
        StringBuilder stringBuilder = new StringBuilder();
        block0: while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group == null) continue;
                stringBuilder.append(group).append(" \n");
                continue block0;
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return "Invalid response received";
    }

    public String getHtml() {
        return this.html;
    }
}

