/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.sender;

import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.sender.HtmlSubmitException;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import java.io.IOException;
import org.xml.sax.SAXException;

public class DurableGovTalkMessageSender
implements IGovTalkMessageSender {
    final IGovTalkMessageSender sender;

    public DurableGovTalkMessageSender(IGovTalkMessageSender sender) {
        this.sender = sender;
    }

    @Override
    public void cancel() {
        this.sender.cancel();
    }

    @Override
    public String getDefaultUrl() {
        return this.sender.getDefaultUrl();
    }

    @Override
    public IGovTalkMessage send(IGovTalkMessage message) throws IOException, SAXException, SubmitException {
        for (int i = 3; i >= 1; --i) {
            try {
                return this.sender.send(message);
            }
            catch (HtmlSubmitException e) {
                if (i > 1) continue;
                throw e;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IGovTalkMessage send(IGovTalkMessage message, String urlStr) throws IOException, SAXException, SubmitException {
        for (int i = 3; i >= 1; --i) {
            try {
                return this.sender.send(message, urlStr);
            }
            catch (HtmlSubmitException e) {
                if (i > 1) continue;
                throw e;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setDefaultUrl(String url) {
        this.sender.setDefaultUrl(url);
    }
}

