/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;

public class SequenceStream
extends InputStream {
    Iterator<InputStream> iterator;
    InputStream currentStream;

    public SequenceStream(InputStream ... inputStreams) {
        this.iterator = Arrays.asList(inputStreams).iterator();
        this.currentStream = this.iterator.hasNext() ? this.iterator.next() : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public int read() throws IOException {
        int result = this.currentStream.read();
        while (result == -1 && this.iterator.hasNext()) {
            this.currentStream = this.iterator.next();
            result = this.currentStream.read();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = 0;
        while (result < len) {
            int count = this.currentStream.read(b, off + result, len - result);
            if (count > 0) {
                result += count;
                continue;
            }
            if (!this.iterator.hasNext()) break;
            this.currentStream = this.iterator.next();
        }
        return result > 0 ? result : -1;
    }
}

