/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core;

import java.io.IOException;
import java.io.Reader;

public class SequenceReader
extends Reader {
    private Reader reader1;
    private Reader reader2;

    public SequenceReader(Reader reader1, Reader reader2) {
        this.reader1 = reader1;
        this.reader2 = reader2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count1 = -1;
        int count2 = -1;
        if (this.reader1 != null) {
            count1 = this.reader1.read(cbuf, off, len);
        }
        if (this.reader2 != null && (count1 == -1 || count1 < len)) {
            int newLen = count1 == -1 ? len : len - count1;
            int newOff = count1 == -1 ? off : off + count1;
            count2 = this.reader2.read(cbuf, newOff, newLen);
        }
        if (count1 == -1) {
            return count2;
        }
        if (count1 != -1 && count2 == -1) {
            return count1;
        }
        return count1 + count2;
    }

    @Override
    public void close() throws IOException {
        if (this.reader1 != null) {
            try {
                this.reader1.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.reader2 != null) {
            try {
                this.reader2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

