/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.response.ISuccessResponse;
import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.hmrcMark.HMRCMarkException;
import com.selima.fbi.submission.IGovTalkMessageFactory;
import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.ISubmissionContext;
import com.selima.fbi.submission.ISubmitResult;
import com.selima.fbi.submission.LoggedSubmissionProcessor;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.exception.GovTalkMessageCreateException;
import com.selima.fbi.user.IUser;
import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.w3c.dom.Node;

public class XMLSignatureSubmissionProcessor
extends LoggedSubmissionProcessor {
    public XMLSignatureSubmissionProcessor(ISubmissionContext context) {
        super(context);
        this.messageFactory = new SmartGovTalkMessageFactory(this.messageFactory);
    }

    @Override
    public ISubmitResult submit(IPAYEMessage data) throws SubmitException, IOException {
        ISuccessResponse response;
        Node xmlSignature;
        ISubmitResult result = super.submit(data);
        if (result.getResponse() instanceof ISuccessResponse && (xmlSignature = HMRCMark.xmlSignatureOf(new ByteArrayInputStream((response = (ISuccessResponse)result.getResponse()).getBytes()))) != null) {
            try {
                InputStream lastSubmissionRequest = ((SmartGovTalkMessageFactory)this.messageFactory).lastSubmisssionRequest.getGovTalkMessage().getXMLStream();
                HMRCMark.checkXMLSignature(lastSubmissionRequest, xmlSignature);
                LogAPI.logSevere((String)"HMRC mark validation succeded");
            }
            catch (HMRCMarkException e) {
                e.setCorrelationID(result.getCorrelationID());
                LogAPI.logSevere((Throwable)e);
                LogAPI.logSevere((String)((SmartGovTalkMessageFactory)this.messageFactory).lastSubmisssionRequest.getGovTalkMessage().toXML());
                LogAPI.logSevere((String)new String(response.getBytes(), "UTF-8"));
            }
        }
        return result;
    }

    static final class SmartGovTalkMessageFactory
    implements IGovTalkMessageFactory {
        final IGovTalkMessageFactory factory;
        IGovTalkRequest lastSubmisssionRequest;

        SmartGovTalkMessageFactory(IGovTalkMessageFactory factory) {
            this.factory = factory;
        }

        @Override
        public IGovTalkRequest createDataRequest(IUser user, String msgClass, Date from, Date to) throws GovTalkMessageCreateException {
            return this.factory.createDataRequest(user, msgClass, from, to);
        }

        @Override
        public IGovTalkRequest createDeleteRequest(IUser user, String msgClass, String correlationID) throws GovTalkMessageCreateException {
            return this.factory.createDeleteRequest(user, msgClass, correlationID);
        }

        @Override
        public IGovTalkRequest createSubmissionPoll(IUser user, String msgClass, String correlationID) throws GovTalkMessageCreateException {
            return this.factory.createSubmissionPoll(user, msgClass, correlationID);
        }

        @Override
        public IGovTalkRequest createSubmissionRequest(IUser user, String msgClass) throws GovTalkMessageCreateException {
            this.lastSubmisssionRequest = this.factory.createSubmissionRequest(user, msgClass);
            return this.lastSubmisssionRequest;
        }
    }
}

