/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.crypto.Base64;

public class MessageDigest {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";

    public static String getDigest(String str, String algorithm) throws Exception {
        java.security.MessageDigest md = java.security.MessageDigest.getInstance(algorithm);
        md.update(str.getBytes());
        byte[] hash = md.digest();
        return Base64.encodeBytes(hash);
    }

    public static void main(String[] args) {
        String usage = "MessageDigest Utility: \n  usage: java com.selima.fbi.util.MessageDigest -MD5|-SHA-1 <string>\n\n";
        if (args.length != 2) {
            System.out.println(usage);
            System.exit(1);
        }
        try {
            if ("-MD5".equals(args[0])) {
                System.out.println(MessageDigest.getDigest(args[1], MD5));
            } else if ("-SHA-1".equals(args[0])) {
                System.out.println(MessageDigest.getDigest(args[1], SHA1));
            } else {
                System.out.println(usage);
                System.exit(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

