/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IHeader;
import com.selima.fbi.submission.core.IIDAuthentication;
import com.selima.fbi.submission.core.IKey;
import com.selima.fbi.submission.core.ISenderDetails;
import com.selima.fbi.submission.core.IXMLObject;
import com.selima.fbi.submission.exception.GovTalkValidatorException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class GovTalkRequestValidator {
    public static void validateSubmissionRequest(IGovTalkRequest request) throws GovTalkValidatorException {
        IXMLObject details;
        IHeader header;
        if (request.getType() != 1) {
            throw new GovTalkValidatorException("GovTalk Request is not submission request!");
        }
        LinkedList<String> errors = new LinkedList<String>();
        IGovTalkMessage msg = request.getGovTalkMessage();
        if (!"2.0".equals(msg.getEnvelopeVersion())) {
            errors.add("Invalid envelope version - should be 2.0 not " + msg.getEnvelopeVersion());
        }
        if ((header = msg.getHeader()) == null) {
            errors.add("Header element is missing");
        } else {
            details = header.getMessageDetails();
            if (details == null) {
                errors.add("Header/MessageDetails element is missing");
            } else {
                String transformation;
                String pattern;
                String auditID;
                String value;
                String pattern2;
                if (details.getMsgClass() == null || details.getMsgClass().trim().length() == 0) {
                    errors.add("Mandatory Header/MessageDetails/Class element is null or empty");
                }
                if (!"request".equals(details.getQualifier())) {
                    errors.add("Mandatory Header/MessageDetails/Qualifier element must have value: request");
                }
                if (!"submit".equals(details.getFunction())) {
                    errors.add("Mandatory Header/MessageDetails/Function element must have value: submit");
                }
                if (details.getTransactionID() != null && !GovTalkRequestValidator.checkPattern(pattern2 = "[0-9A-F]{0,32}", value = details.getTransactionID())) {
                    errors.add("Optional Header/MessageDetails/TransactionID elements does not match " + pattern2 + " for value: " + value);
                }
                if ((auditID = details.getAuditID()) != null && !GovTalkRequestValidator.checkPattern(pattern = "[0-9A-F]{0,32}", auditID)) {
                    errors.add("Optional Header/MessageDetails/AuditID elements does not match " + pattern + " for value: " + auditID);
                }
                if (details.getCorrelationID() != null && details.getCorrelationID().trim().length() > 0) {
                    errors.add("Mandatory Header/MessageDetails/CollerationID element must be empty");
                }
                if (details.getResponseEndPoint() != null && details.getResponseEndPoint().trim().length() > 0) {
                    errors.add("Optional Header/MessageDetails/ResponseEndPoint element must be empty");
                }
                if (!("HTML".equals(transformation = details.getTransformation()) || "text".equals(transformation) || "XML".equals(transformation))) {
                    errors.add("Mandatory Header/MessageDetails/Transformation element has invalid value: " + transformation);
                }
                if (details.getTimestamp() != null && details.getTimestamp().trim().length() > 0) {
                    errors.add("Optional Header/MessageDetails/GatewayTimestamp element must be empty");
                }
            }
            ISenderDetails senderDetails = header.getSenderDetails();
            if (senderDetails == null) {
                errors.add("SenderDetails element is missing");
            } else {
                IIDAuthentication idAuthentication = senderDetails.getIDAuthentication();
                if (idAuthentication == null) {
                    errors.add("IDAuthentication element is missing");
                } else {
                    if (idAuthentication.getSenderID() == null || idAuthentication.getSenderID().trim().length() == 0) {
                        errors.add("Mandatory Header/SenderDetails/IDAuthentication/SenderID is empty or null");
                    }
                    if (idAuthentication.getMethod() == null || !"clear".equals(idAuthentication.getMethod()) && !"MD5".equals(idAuthentication.getMethod())) {
                        errors.add("Mandatory Header/SenderDetails/IDAuthentication/Method is not defined or has invalid value:" + idAuthentication.getMethod());
                    }
                    if (idAuthentication.getValue() == null || idAuthentication.getValue().trim().length() == 0) {
                        errors.add("Mandatory Header/SenderDetails/IDAuthentication/Value is empty or null");
                    }
                }
            }
        }
        details = msg.getDetails();
        if (details == null) {
            errors.add("GovTalkDetails element is missing");
        } else {
            String[] organizations;
            IKey[] keys = details.getKeys();
            if (keys == null || keys.length == 0) {
                errors.add("GovTalkDetails/Keys element is missing or has no key elements");
            }
            if ((organizations = details.getOrganization()) != null) {
                for (int i = 0; i < organizations.length; ++i) {
                    if (GovTalkRequestValidator.checkString(organizations[i], 1, 64)) continue;
                    errors.add("Organization element is invalid: " + organizations[i]);
                }
            }
            if (details.getGatewayValidation() != null) {
                errors.add("GatewayValidation element should not be present");
            }
            if (details.getErrors() != null) {
                errors.add("GovTalkError elements should not be present");
            }
            if (details.getGatewayAdditions() != null) {
                errors.add("GatewayAdditions element should not be present");
            }
        }
        if (msg.getBody() == null) {
            errors.add("Mandatory Body element must be defined");
        }
        if (errors.size() > 0) {
            throw new GovTalkValidatorException(errors.toArray(new String[0]));
        }
    }

    private static boolean checkString(String value, int min, int max) {
        if (value == null) {
            return false;
        }
        return value.length() > 0 && value.length() < 65;
    }

    public static void validateSubmissionPoll(IGovTalkRequest request) throws GovTalkValidatorException {
        IKey[] keys;
        IXMLObject details;
        IHeader header;
        if (request.getType() != 2) {
            throw new GovTalkValidatorException("GovTalk Request is not poll request!: " + request.getType());
        }
        LinkedList<String> errors = new LinkedList<String>();
        IGovTalkMessage msg = request.getGovTalkMessage();
        if (!"2.0".equals(msg.getEnvelopeVersion())) {
            errors.add("Invalid envelope version - should be 2.0 not " + msg.getEnvelopeVersion());
        }
        if ((header = msg.getHeader()) == null) {
            errors.add("Header element is missing");
        } else {
            details = header.getMessageDetails();
            if (details == null) {
                errors.add("Header/MessageDetails element is missing");
            } else {
                String transformation;
                String pattern;
                String auditID;
                String value;
                String pattern2;
                if (details.getMsgClass() == null || details.getMsgClass().trim().length() == 0) {
                    errors.add("Mandatory Header/MessageDetails/Class element is null or empty");
                }
                if (!"poll".equals(details.getQualifier())) {
                    errors.add("Mandatory Header/MessageDetails/Qualifier element must have value: poll");
                }
                if (!"submit".equals(details.getFunction())) {
                    errors.add("Mandatory Header/MessageDetails/Function element must have value: submit");
                }
                if (details.getTransactionID() != null && !GovTalkRequestValidator.checkPattern(pattern2 = "[0-9A-F]{0,32}", value = details.getTransactionID())) {
                    errors.add("Optional Header/MessageDetails/TransactionID elements does not match " + pattern2 + " for value: " + value);
                }
                if ((auditID = details.getAuditID()) != null && !GovTalkRequestValidator.checkPattern(pattern = "[0-9A-F]{0,32}", auditID)) {
                    errors.add("Optional Header/MessageDetails/AuditID elements does not match " + pattern + " for value: " + auditID);
                }
                if (details.getCorrelationID() == null || details.getCorrelationID().trim().length() == 0) {
                    errors.add("Mandatory Header/MessageDetails/CollerationID element is null or empty");
                }
                if (!("HTML".equals(transformation = details.getTransformation()) || "text".equals(transformation) || "XML".equals(transformation))) {
                    errors.add("Mandatory Header/MessageDetails/Transformation element has invalid value: " + transformation);
                }
                if (details.getTimestamp() != null && details.getTimestamp().trim().length() > 0) {
                    errors.add("Optional Header/MessageDetails/GatewayTimestamp element must be empty");
                }
            }
            ISenderDetails senderDetails = header.getSenderDetails();
            if (senderDetails != null && senderDetails.getIDAuthentication() != null && senderDetails.getIDAuthentication().getSenderID() != null) {
                errors.add("SenderDetails element must be empty");
            }
        }
        details = msg.getDetails();
        if (details != null && (keys = details.getKeys()) != null && keys.length > 0) {
            errors.add("GovTalkDetails/Keys/Key elements must not be present");
        }
        if (msg.getBody() != null) {
            errors.add("Mandatory Body element must be empty");
        }
        if (errors.size() > 0) {
            throw new GovTalkValidatorException(errors.toArray(new String[0]));
        }
    }

    public static void validateDeleteRequest(IGovTalkRequest request) throws GovTalkValidatorException {
        IKey[] keys;
        IXMLObject details;
        IHeader header;
        if (request.getType() != 4) {
            throw new GovTalkValidatorException("GovTalk Request is not delete request!");
        }
        LinkedList<String> errors = new LinkedList<String>();
        IGovTalkMessage msg = request.getGovTalkMessage();
        if (!"2.0".equals(msg.getEnvelopeVersion())) {
            errors.add("Invalid envelope version - should be 2.0 not " + msg.getEnvelopeVersion());
        }
        if ((header = msg.getHeader()) == null) {
            errors.add("Header element is missing");
        } else {
            details = header.getMessageDetails();
            if (details == null) {
                errors.add("Header/MessageDetails element is missing");
            } else {
                String transformation;
                if (details.getMsgClass() == null || details.getMsgClass().trim().length() == 0) {
                    errors.add("Mandatory Header/MessageDetails/Class element is null or empty");
                }
                if (!"request".equals(details.getQualifier())) {
                    errors.add("Mandatory Header/MessageDetails/Qualifier element must have value: request");
                }
                if (!"delete".equals(details.getFunction())) {
                    errors.add("Mandatory Header/MessageDetails/Function element must have value: delete");
                }
                if (details.getCorrelationID() == null || details.getCorrelationID().trim().length() == 0) {
                    errors.add("Mandatory Header/MessageDetails/CollerationID element is null or empty");
                }
                if (!("HTML".equals(transformation = details.getTransformation()) || "text".equals(transformation) || "XML".equals(transformation))) {
                    errors.add("Mandatory Header/MessageDetails/Transformation element has invalid value: " + transformation);
                }
                if (details.getTimestamp() != null && details.getTimestamp().trim().length() > 0) {
                    errors.add("Optional Header/MessageDetails/GatewayTimestamp element must be empty");
                }
            }
            ISenderDetails senderDetails = header.getSenderDetails();
            if (senderDetails != null && senderDetails.getIDAuthentication() != null && senderDetails.getIDAuthentication().getSenderID() != null) {
                errors.add("SenderDetails element must be empty");
            }
        }
        details = msg.getDetails();
        if (details != null && (keys = details.getKeys()) != null && keys.length > 0) {
            errors.add("GovTalkDetails/Keys/Key elements should not be present");
        }
        if (msg.getBody() != null) {
            errors.add("Mandatory Body element must be empty");
        }
        if (errors.size() > 0) {
            throw new GovTalkValidatorException(errors.toArray(new String[0]));
        }
    }

    private static boolean checkPattern(String regExpr, String value) {
        Pattern pattern = Pattern.compile(regExpr);
        return pattern.matcher(value).matches();
    }
}

