/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IKey;
import com.selima.fbi.submission.core.IMessageDetails;
import com.selima.fbi.submission.core.MutableGovTalkDetails;
import com.selima.fbi.submission.core.MutableGovTalkMessage;
import com.selima.fbi.submission.core.MutableIDAuthentication;
import com.selima.fbi.submission.core.MutableMessageDetails;
import com.selima.fbi.submission.core.MutableSenderDetails;
import com.selima.fbi.user.IUser;

public class GovTalkRequest
implements IGovTalkRequest {
    private MutableGovTalkMessage msg;

    public GovTalkRequest(MutableGovTalkMessage msg, IUser user, String msgClass) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        this.msg = msg;
        this.setClass(msgClass);
        if (user != null && msg.getHeader() != null && msg.getHeader().getSenderDetails() != null) {
            MutableIDAuthentication authentication = (MutableIDAuthentication)msg.getHeader().getSenderDetails().getIDAuthentication();
            if (authentication == null) {
                authentication = new MutableIDAuthentication();
                ((MutableSenderDetails)msg.getHeader().getSenderDetails()).setIDAuthentication(authentication);
            }
            authentication.setMethod("clear");
            authentication.setValue(user.getPassword());
            authentication.setSenderID(user.getLogin());
        }
    }

    @Override
    public void setTransformation(String transformation) {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            ((MutableMessageDetails)this.msg.getHeader().getMessageDetails()).setTransformation(transformation);
        }
    }

    @Override
    public void setBody(byte[] body) {
        this.msg.setBody(body);
    }

    @Override
    public void setCorrelationID(String correlationID) {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            ((MutableMessageDetails)this.msg.getHeader().getMessageDetails()).setCorrelationID(correlationID);
        }
    }

    @Override
    public void setClass(String msgClass) {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            ((MutableMessageDetails)this.msg.getHeader().getMessageDetails()).setMsgClass(msgClass);
        }
    }

    @Override
    public void setKeys(IKey[] keys) {
        if (keys != null && this.msg.getDetails() != null) {
            for (int i = 0; i < keys.length; ++i) {
                ((MutableGovTalkDetails)this.msg.getDetails()).addKey(keys[i]);
            }
        }
    }

    @Override
    public IGovTalkMessage getGovTalkMessage() {
        return this.msg;
    }

    @Override
    public int getType() {
        if (this.msg == null) {
            return -1;
        }
        IMessageDetails details = this.msg.getHeader().getMessageDetails();
        String qualifier = details.getQualifier();
        String function = details.getFunction();
        if ("request".equals(qualifier) && "submit".equals(function)) {
            return 1;
        }
        if ("poll".equals(qualifier) && "submit".equals(function)) {
            return 2;
        }
        if ("request".equals(qualifier) && "list".equals(function)) {
            return 3;
        }
        if ("request".equals(qualifier) && "delete".equals(function)) {
            return 4;
        }
        return -1;
    }

    @Override
    public void setTransactionID(String transactionID) {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            ((MutableMessageDetails)this.msg.getHeader().getMessageDetails()).setTransactionID(transactionID);
        }
    }
}

