/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.submission.GovTalkMessageFactory;
import com.selima.fbi.submission.IGovTalkMessageFactory;
import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.submission.ISubmissionContext;
import com.selima.fbi.submission.ISubmissionProcessor;
import com.selima.fbi.submission.NetworkTrackingSender;
import com.selima.fbi.submission.SubmissionState;
import com.selima.fbi.user.IUser;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;

public abstract class AbstractSubmissionProcessor
implements ISubmissionProcessor {
    private ISubmissionContext context;
    private SubmissionState state = SubmissionState.INIT;
    protected IGovTalkMessageFactory messageFactory;
    private EventBroadcast<PAYEServiceListener> payeListeners;
    private Object delayObj = new Object();
    protected volatile boolean isActive;
    protected volatile boolean cancelFlag;
    protected NetworkTrackingSender sender;
    protected int stepLimit;

    protected AbstractSubmissionProcessor(ISubmissionContext context) {
        this.context = context;
        this.stepLimit = context.getStepLimit();
        this.sender = new NetworkTrackingSender(context.getSender(), context.getNetworkTracker());
        this.messageFactory = new GovTalkMessageFactory();
        this.payeListeners = EventBroadcastFactory.createEventBroadcast(PAYEServiceListener.class);
    }

    protected IUser getCurrentUser() {
        return this.context.getCurrentUser();
    }

    protected void setState(SubmissionState state) {
        this.state = state;
        ((PAYEServiceListener)this.payeListeners.getListener()).stateChanged(state, 0);
    }

    public SubmissionState getState() {
        return this.state;
    }

    protected void changeState(SubmissionState newState, IGovTalkRequest request, IGovTalkResponse response, String url) {
        if (!this.checkTransmission(this.state, newState)) {
            throw new IllegalArgumentException("Illegal transmission " + (Object)((Object)this.state) + " -> " + (Object)((Object)newState));
        }
        this.state = newState;
        ((PAYEServiceListener)this.payeListeners.getListener()).stateChanged(newState, response != null ? response.getPollInterval() : 0);
    }

    protected boolean checkTransmission(SubmissionState oldState, SubmissionState newState) {
        if (oldState == SubmissionState.INIT && (newState == SubmissionState.SENDING || newState == SubmissionState.POLLING || newState == SubmissionState.CANCELED)) {
            return true;
        }
        if (oldState == SubmissionState.SENDING && (newState == SubmissionState.ERROR || newState == SubmissionState.DELETING_RESPONSE || newState == SubmissionState.POLLING || newState == SubmissionState.SENDING || newState == SubmissionState.CANCELED || newState == SubmissionState.RESPONSE_RECEIVED)) {
            return true;
        }
        if (oldState == SubmissionState.POLLING && (newState == SubmissionState.ERROR || newState == SubmissionState.DELETING_RESPONSE || newState == SubmissionState.POLLING || newState == SubmissionState.CANCELED || newState == SubmissionState.RESPONSE_RECEIVED)) {
            return true;
        }
        if (oldState == SubmissionState.RESPONSE_RECEIVED && (newState == SubmissionState.DELETING_RESPONSE || newState == SubmissionState.CANCELED)) {
            return true;
        }
        return oldState == SubmissionState.DELETING_RESPONSE && (newState == SubmissionState.ERROR || newState == SubmissionState.DELETING_RESPONSE || newState == SubmissionState.CANCELED || newState == SubmissionState.FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(int seconds) {
        if (seconds == 0) {
            return;
        }
        Object object = this.delayObj;
        synchronized (object) {
            try {
                this.delayObj.wait(seconds * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.isActive) {
            this.sender.cancel();
            this.cancelFlag = true;
            Object object = this.delayObj;
            synchronized (object) {
                this.delayObj.notifyAll();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void addSubmitListener(PAYEServiceListener listener) {
        this.payeListeners.addListener((Object)listener);
    }

    @Override
    public void removeSubmitListener(PAYEServiceListener listener) {
        this.payeListeners.removeListener((Object)listener);
    }
}

