/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import asjava.uniclientlibs.UniTokens;
import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.storage.uv.UvFilesAccess;
import com.selima.fbi.storage.uv.UvStorageException;
import com.selima.fbi.storage.uv.UvStorageFileNames;
import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UvStorageProvider
implements IStorageProvider {
    private String innerSpace;
    private String outerSpace;
    private String alias;
    private boolean managedLocally;
    private String contentType;
    private UvFilesAccess uvAccess;
    private int maxFileRecordSize = 0x100000;

    public UvStorageProvider(UvFilesAccess filesAccess, String alias, String contentType) {
        this.uvAccess = filesAccess;
        this.contentType = contentType;
        this.alias = alias;
    }

    @Override
    public boolean contains(String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)("UvStorageProvider.contains() begin: " + id));
        boolean result = this.uvAccess.contains(this.getIndexFileName(), id);
        LogAPI.logFiner((String)("UvStorageProvider.contains() end: " + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(String id) throws IOException, CancelException {
        LogAPI.logFiner((String)("UvStorageProvider.getInputStream() begin: " + id));
        try {
            final List<String> fragmentIds = this.getFragmentIds(id);
            SequenceInputStream sequenceInputStream = new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
                Iterator<String> idIterator;
                {
                    this.idIterator = fragmentIds.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.idIterator.hasNext();
                }

                @Override
                public InputStream nextElement() {
                    IOException exception;
                    try {
                        String recordFragment = UvStorageProvider.this.uvAccess.read(UvStorageProvider.this.getDataFileName(), this.idIterator.next());
                        recordFragment = recordFragment.replace(UniTokens.FM_CHAR.charValue(), '\n');
                        recordFragment = UvStorageProvider.this.decodeUnicodeEscapeSequences(recordFragment);
                        return new ByteArrayInputStream(recordFragment.getBytes());
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    catch (CancelException e) {
                        exception = new UvStorageException(e);
                    }
                    final IOException failure = exception;
                    return new InputStream(){

                        @Override
                        public int read() throws IOException {
                            throw failure;
                        }
                    };
                }
            });
            return sequenceInputStream;
        }
        finally {
            LogAPI.logFiner((String)"UvStorageProvider.getInputStream() end");
        }
    }

    @Override
    public OutputStream getOutputStream(String id) throws UvStorageException {
        return new UvOutputStream(id);
    }

    @Override
    public void delete(String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)("UvStorageProvider.delete() begin: " + id));
        List<String> fragmentIds = this.getFragmentIds(id);
        for (String fragmentId : fragmentIds) {
            this.uvAccess.delete(this.getDataFileName(), fragmentId);
        }
        this.uvAccess.delete(this.getIndexFileName(), id);
        LogAPI.logFiner((String)"UvStorageProvider.delete() end");
    }

    List<String> getFragmentIds(String id) throws UvStorageException, CancelException {
        return this.uvAccess.readMultivalues(this.getIndexFileName(), id);
    }

    @Override
    public String[] getIds() throws UvStorageException, CancelException {
        LogAPI.logFiner((String)"UvStorageProvider.getIds() begin");
        List<String> ids = this.uvAccess.getIds(this.getIndexFileName());
        LogAPI.logFiner((String)("UvStorageProvider.getIds() end: " + ids));
        return ids.toArray(new String[0]);
    }

    @Override
    public void setInnerSpace(String space) {
        LogAPI.logFiner((String)("UvStorageProvider.setInnerSpace(" + space + ")"));
        this.innerSpace = space;
    }

    @Override
    public void setOuterSpace(String space) {
        LogAPI.logFiner((String)("UvStorageProvider.setOuterSpace(" + space + ")"));
        this.outerSpace = space;
    }

    String getAlias() {
        return this.alias;
    }

    int getMaxFileRecordSize() {
        return this.maxFileRecordSize;
    }

    void setMaxFileRecordSize(int maxFileRecordSize) {
        this.maxFileRecordSize = maxFileRecordSize;
    }

    @Override
    public void begin() throws IOException, CancelException {
        if (!this.uvAccess.isInTransaction()) {
            this.uvAccess.begin();
            this.managedLocally = this.uvAccess.isInTransaction();
        }
    }

    @Override
    public void commit() throws IOException, CancelException {
        if (this.managedLocally) {
            try {
                this.uvAccess.commit();
            }
            finally {
                this.managedLocally = false;
            }
        }
    }

    @Override
    public void rollback() throws IOException, CancelException {
        if (this.managedLocally) {
            try {
                this.uvAccess.rollback();
            }
            finally {
                this.managedLocally = false;
            }
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.uvAccess.isInTransaction();
    }

    String getIndexFileName() {
        return UvStorageFileNames.createIndexFileName(this.alias, this.outerSpace, this.innerSpace);
    }

    String getDataFileName() {
        return UvStorageFileNames.createDataFileName(this.alias, this.outerSpace, this.innerSpace);
    }

    private String decodeUnicodeEscapeSequences(String recordFragment) {
        if (recordFragment.contains("\\u")) {
            StringBuffer result = new StringBuffer();
            Matcher matcher = Pattern.compile("\\\\u(\\d{4})").matcher(recordFragment);
            while (matcher.find()) {
                char unicodeChar = (char)Integer.parseInt(matcher.group(1));
                matcher.appendReplacement(result, String.valueOf(unicodeChar));
            }
            recordFragment = matcher.appendTail(result).toString();
        }
        return recordFragment;
    }

    private String encodeUnicodeEscapeSequences(CharBuffer cb) {
        String databaseEncoding = System.getProperty("clientencoding", "CP1252");
        CharsetEncoder encoder = Charset.forName(databaseEncoding).newEncoder();
        StringBuilder result = new StringBuilder();
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (encoder.canEncode(c)) {
                result.append(c);
                continue;
            }
            result.append(String.format("\\u%04d", c));
        }
        return result.toString();
    }

    class UvOutputStream
    extends OutputStream {
        ByteBuffer buffer;
        CharsetDecoder utf8Decoder;
        DecimalFormat numberFormat;
        List<String> fragmentIds;
        int fragmentIndex;
        boolean closed;
        String id;

        public UvOutputStream(String id) {
            this.buffer = ByteBuffer.allocate(UvStorageProvider.this.getMaxFileRecordSize());
            this.utf8Decoder = Charset.forName("UTF-8").newDecoder();
            this.numberFormat = new DecimalFormat("0000");
            this.fragmentIds = new ArrayList<String>();
            this.fragmentIndex = 0;
            this.id = id;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put((byte)b);
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
        }

        @Override
        public void flush() throws UvStorageException {
            if (this.buffer.position() > 0) {
                try {
                    String fragmentId = this.id + "." + this.numberFormat.format(++this.fragmentIndex) + "." + UvStorageProvider.this.contentType;
                    this.fragmentIds.add(fragmentId);
                    LogAPI.logFiner((String)("UvStorageProvider.copyFromOsFileToUvFileRecord() begin: " + this.id));
                    this.buffer.flip();
                    CharBuffer cb = this.utf8Decoder.decode(this.buffer);
                    String string = UvStorageProvider.this.encodeUnicodeEscapeSequences(cb);
                    UvStorageProvider.this.uvAccess.write(UvStorageProvider.this.getDataFileName(), fragmentId, string);
                    this.buffer.compact();
                    LogAPI.logFiner((String)"UvStorageProvider.copyFromOsFileToUvFileRecord() end");
                }
                catch (CancelException | CharacterCodingException e) {
                    throw new UvStorageException(e);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.flush();
                try {
                    UvStorageProvider.this.uvAccess.writeMultivalues(UvStorageProvider.this.getIndexFileName(), this.id, this.fragmentIds);
                }
                catch (CancelException e) {
                    throw new UvStorageException(e);
                }
            }
        }
    }
}

