/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import asjava.uniclientlibs.UniException;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSessionException;
import asjava.uniobjects.UniTransaction;
import com.selima.fbi.CancelException;
import com.selima.fbi.storage.uv.AbstractUvSession;
import com.selima.fbi.storage.uv.IFileTypeProvider;
import com.selima.fbi.storage.uv.StandaloneUvSession;
import com.selima.fbi.storage.uv.TransactionalFileWork;
import com.selima.fbi.storage.uv.UvStorageException;
import com.selima.fbi.storage.uv.UvStorageLockException;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.util.logging.LogAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransactionalUvSession
extends AbstractUvSession {
    private UniTransaction transaction;
    private Map<String, UniFile> openFiles;
    private IFileTypeProvider fileTypeProvider;
    private StandaloneUvSession standaloneSession;
    private int maxLockAttemptsCount = 20;

    public TransactionalUvSession(PayrollServerSpec serverSpec, IFileTypeProvider fileTypeProvider, StandaloneUvSession standaloneSession) {
        super(serverSpec);
        this.fileTypeProvider = fileTypeProvider;
        this.standaloneSession = standaloneSession;
        this.openFiles = new HashMap<String, UniFile>();
    }

    public synchronized boolean isInTransaction() {
        return this.transaction != null;
    }

    public synchronized boolean isFileOpen(String fileName) {
        return this.openFiles.containsKey(fileName);
    }

    public synchronized void begin() throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".begin() begin"));
        if (this.isInTransaction()) {
            throw new IllegalStateException("There is an active transaction already");
        }
        this.execute(new AbstractUvSession.UniObjectsWork<Void>(){

            @Override
            public Void run() throws UniException, UvStorageException, CancelException {
                TransactionalUvSession.this.transaction = TransactionalUvSession.this.getUniSession().transaction();
                TransactionalUvSession.this.checkCancelRequested();
                TransactionalUvSession.this.transaction.begin();
                return null;
            }

            @Override
            public int getFlags() {
                return 6;
            }
        });
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".begin() end"));
    }

    public synchronized void commit() throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".commit() begin"));
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No transaction is active");
        }
        try {
            this.execute(new AbstractUvSession.UniObjectsWork<Void>(){

                @Override
                public Void run() throws UniException, UvStorageException, CancelException {
                    TransactionalUvSession.this.checkCancelRequested();
                    TransactionalUvSession.this.checkCancelRequested();
                    TransactionalUvSession.this.transaction.commit();
                    TransactionalUvSession.this.closeFiles();
                    return null;
                }

                @Override
                public int getFlags() {
                    return 5;
                }
            });
        }
        finally {
            this.cleanupAfterTransaction();
        }
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".commit() end"));
    }

    public synchronized void rollback() throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".rollback() begin"));
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No transaction is active");
        }
        try {
            this.execute(new AbstractUvSession.UniObjectsWork<Void>(){

                @Override
                public Void run() throws UniException, UvStorageException, CancelException {
                    TransactionalUvSession.this.checkCancelRequested();
                    TransactionalUvSession.this.transaction.rollback();
                    TransactionalUvSession.this.closeFiles();
                    return null;
                }

                @Override
                public int getFlags() {
                    return 5;
                }
            });
        }
        finally {
            this.cleanupAfterTransaction();
        }
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".rollback() end"));
    }

    public synchronized <T> T executeTransactionalFileWork(final String fileName, final TransactionalFileWork<T> work) throws UvStorageException, CancelException {
        Object result = this.execute(new AbstractUvSession.UniObjectsWork<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T run() throws UniException, UvStorageException, CancelException {
                UniFile file = null;
                boolean needToClose = false;
                try {
                    file = (UniFile)TransactionalUvSession.this.openFiles.get(fileName);
                    if (file == null) {
                        file = TransactionalUvSession.this.openFile(fileName);
                        if (TransactionalUvSession.this.isInTransaction()) {
                            TransactionalUvSession.this.openFiles.put(fileName, file);
                            TransactionalUvSession.this.lockFile(file);
                        }
                    }
                    TransactionalUvSession.this.checkCancelRequested();
                    Object result = work.run(file);
                    needToClose = !TransactionalUvSession.this.isInTransaction();
                    Object t = result;
                    return t;
                }
                finally {
                    if (needToClose) {
                        try {
                            file.close();
                        }
                        catch (UniFileException e) {
                            LogAPI.logWarning((Throwable)e);
                        }
                    }
                }
            }

            @Override
            public int getFlags() {
                return TransactionalUvSession.this.isInTransaction() ? 0 : 7;
            }
        });
        return result;
    }

    void setMaxLockAttemptsCount(int maxLockAttemptsCount) {
        this.maxLockAttemptsCount = maxLockAttemptsCount;
    }

    private void cleanupAfterTransaction() {
        this.openFiles.clear();
        this.transaction = null;
    }

    private void closeFiles() throws CancelException, UniFileException {
        Iterator<Map.Entry<String, UniFile>> it = this.openFiles.entrySet().iterator();
        while (it.hasNext()) {
            this.checkCancelRequested();
            it.next().getValue().close();
            it.remove();
        }
    }

    private UniFile openFile(String fileName) throws UniException, UvStorageException, CancelException {
        try {
            this.checkCancelRequested();
            return this.getUniSession().openFile((Object)fileName);
        }
        catch (UniSessionException e) {
            if (e.getErrorCode() == 14002) {
                String fileType = this.fileTypeProvider.getFileType(fileName);
                this.checkCancelRequested();
                this.standaloneSession.robustCreateFile(fileName, fileType);
                this.checkCancelRequested();
                return this.getUniSession().openFile((Object)fileName);
            }
            throw e;
        }
    }

    private void lockFile(UniFile file) throws UniException, UvStorageException, CancelException {
        if (this.maxLockAttemptsCount == 0) {
            return;
        }
        for (int i = 0; i < this.maxLockAttemptsCount; ++i) {
            try {
                this.checkCancelRequested();
                file.lockFile();
                return;
            }
            catch (UniFileException e) {
                if (e.getErrorCode() == 30002) {
                    if (i >= this.maxLockAttemptsCount - 1) continue;
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ee) {
                        break;
                    }
                }
                throw e;
            }
        }
        this.checkCancelRequested();
        throw new UvStorageLockException(file.getFileName());
    }
}

