/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.migration;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.service.MailServiceFactory;
import com.selima.fbi.storage.IExtendedStorageFactory;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.storage.migration.IMigration;
import com.selima.fbi.storage.migration.OldVersionException;
import com.selima.fbi.storage.migration.StorableRevision;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Migrations {
    final IExtendedStorageFactory fromFactory;
    final IExtendedStorageFactory toFactory;

    public Migrations(IExtendedStorageFactory fromFactory, IExtendedStorageFactory toFactory) {
        this.fromFactory = fromFactory;
        this.toFactory = toFactory;
    }

    public boolean areNeeded() throws OldVersionException, IOException, CancelException {
        LogAPI.logFine((String)"Checking the need for storage migration");
        return new Transaction(this.toFactory).run(new Transaction.InteractionR1<Boolean, OldVersionException>(){

            @Override
            public Boolean run() throws OldVersionException, IOException, CancelException {
                int currentRevision = Migrations.this.currentRevision();
                for (String alias : MailServiceFactory.getAliases(MailServiceConfig.getInitParamaters())) {
                    Migrations.this.toFactory.setOuterSpace(alias);
                    if (!Migrations.this.migrationIsNeeded(Migrations.this.toFactory, currentRevision)) continue;
                    LogAPI.logFine((String)"Needs upgrade to revision {0} ", (Object)currentRevision);
                    return true;
                }
                return false;
            }
        });
    }

    private boolean migrationIsNeeded(IStorageFactory factory, int programRevision) throws IOException, OldVersionException, CancelException {
        IStorage<StorableRevision> revisionStorage = factory.getStorage("revision", StorableRevision.class);
        StorableRevision dbRevision = this.storedRevision(revisionStorage);
        if (dbRevision.after(programRevision)) {
            throw new OldVersionException(programRevision, dbRevision.getValue());
        }
        for (IMigration migration : this.migrations()) {
            if (dbRevision.after(migration.getLatestApplicableRevision())) continue;
            return true;
        }
        return false;
    }

    public void run() throws OldVersionException, IOException, CancelException {
        new Transaction(this.toFactory).run(new Transaction.InteractionV1<OldVersionException>(){

            @Override
            public void run() throws OldVersionException, IOException, CancelException {
                new Transaction(Migrations.this.fromFactory).run(new Transaction.InteractionV1<OldVersionException>(){

                    @Override
                    public void run() throws OldVersionException, IOException, CancelException {
                        int currentRevision = Migrations.this.currentRevision();
                        for (String alias : MailServiceFactory.getAliases(MailServiceConfig.getInitParamaters())) {
                            Migrations.this.fromFactory.setOuterSpace(alias);
                            Migrations.this.toFactory.setOuterSpace(alias);
                            LogAPI.logInfo((String)"Upgrading {0}/{1}", (Object[])new Object[]{Migrations.this.toFactory.getName(), alias});
                            Migrations.this.migrateService(currentRevision);
                        }
                    }
                });
            }
        });
    }

    void migrateService(int currentRevision) throws IOException, OldVersionException, CancelException {
        IStorage<StorableRevision> revisionStorage = this.toFactory.getStorage("revision", StorableRevision.class);
        StorableRevision dbRevision = this.storedRevision(revisionStorage);
        if (dbRevision.after(currentRevision)) {
            throw new OldVersionException(currentRevision, dbRevision.getValue());
        }
        for (IMigration migration : this.migrations()) {
            int fromRevision = migration.getLatestApplicableRevision();
            if (fromRevision >= currentRevision) {
                throw new IOException("The program contains migration to a newer database revision then the revision of the program itself.");
            }
            if (dbRevision.after(fromRevision)) continue;
            LogAPI.logInfo((String)"Migrating from {0} to {1}", (Object[])new Object[]{dbRevision.getValue(), fromRevision + 1});
            migration.migrate(this.fromFactory, this.toFactory);
            revisionStorage.store(new StorableRevision(fromRevision + 1));
            this.fromFactory.resetTypeInformation();
            this.toFactory.resetTypeInformation();
        }
    }

    private List<IMigration> migrations() {
        ArrayList<IMigration> migrations = new ArrayList<IMigration>();
        Collections.sort(migrations, new Comparator<IMigration>(){

            @Override
            public int compare(IMigration o1, IMigration o2) {
                int result = o1.getLatestApplicableRevision() - o2.getLatestApplicableRevision();
                assert (result != 0) : "There should never be pair of migrations starting from a same revision";
                return result;
            }
        });
        return migrations;
    }

    private StorableRevision storedRevision(IStorage<StorableRevision> revisionStorage) throws IOException, CancelException {
        StorableRevision dbRevision = revisionStorage.contains("revision") ? revisionStorage.load("revision") : new StorableRevision(0);
        return dbRevision;
    }

    private int currentRevision() {
        String string = MailServiceConfig.getInitParameter("svn.revision");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = System.getProperty("svn.revision")) != null) {
            return Integer.parseInt(string);
        }
        assert (MailServiceConfig.isDevelopmentVersion());
        List<IMigration> migrations = this.migrations();
        if (!migrations.isEmpty()) {
            return migrations.get(migrations.size() - 1).getLatestApplicableRevision() + 1;
        }
        return Integer.MAX_VALUE;
    }
}

