/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.memory;

import com.selima.fbi.storage.memory.CompositeId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractInMemoryData<T> {
    private String innerSpace;
    private String outerSpace;
    private Map<CompositeId, T> map = new HashMap<CompositeId, T>();

    AbstractInMemoryData() {
    }

    public CompositeId createId(String id) {
        return new CompositeId(id, this.outerSpace, this.innerSpace);
    }

    public T get(CompositeId id) throws IOException {
        T result = this.map.get(id);
        if (result == null) {
            throw new IOException("No such object in storage " + id);
        }
        return result;
    }

    public void put(CompositeId id, T value) {
        this.map.put(id, value);
    }

    public void setInnerSpace(String innerSpace) {
        this.innerSpace = innerSpace;
    }

    public void setOuterSpace(String outerSpace) {
        this.outerSpace = outerSpace;
    }

    public boolean contains(String id) {
        return this.map.containsKey(new CompositeId(id, this.outerSpace, this.innerSpace));
    }

    public String[] getIds() {
        ArrayList<String> result = new ArrayList<String>(this.map.size());
        for (CompositeId id : this.map.keySet()) {
            if (!id.inSpace(this.outerSpace, this.innerSpace)) continue;
            result.add(id.getId());
        }
        return result.toArray(new String[result.size()]);
    }

    public void delete(String id) throws IOException {
        T olddata = this.map.remove(new CompositeId(id, this.outerSpace, this.innerSpace));
        if (olddata == null) {
            throw new IOException("No such object in storage " + id);
        }
    }
}

