/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.file;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.loader.ILoaderFactory;
import com.selima.fbi.saver.ISaverFactory;
import com.selima.fbi.storage.IExtendedStorageFactorySPI;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.storage.IStorageSPI;
import com.selima.fbi.storage.StorageConfigParser;
import com.selima.fbi.storage.StorageId;
import com.selima.fbi.storage.StorageImpl;
import com.selima.fbi.storage.file.Base64StorageProvider;
import com.selima.fbi.storage.file.CryptoStorageProvider;
import com.selima.fbi.storage.file.DigestStorageProvider;
import com.selima.fbi.storage.file.FileSystemStorageProvider;
import com.selima.fbi.storage.memory.InMemoryStorage;
import com.selima.fbi.storage.transfer.RawRecord;
import com.selima.framework.util.logging.LogAPI;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileStorageFactorySPI
implements IExtendedStorageFactorySPI {
    public static final String ROOT_FOLDER_NAME = "message-box";
    private File baseDir;
    private Map<String, String> properties;
    private ILoaderFactory loaderFactory;
    private ISaverFactory saverFactory;

    public FileStorageFactorySPI(Map<String, String> properties, ILoaderFactory loaderFactory, ISaverFactory saverFactory) {
        this(properties, MailServiceConfig.getBaseDir(), loaderFactory, saverFactory);
    }

    public FileStorageFactorySPI(Map<String, String> properties, File baseDir, ILoaderFactory loaderFactory, ISaverFactory saverFactory) {
        this.properties = properties;
        this.loaderFactory = loaderFactory;
        this.saverFactory = saverFactory;
        this.baseDir = new File(baseDir, ROOT_FOLDER_NAME);
    }

    @Override
    public String getName() {
        return this.baseDir.getPath();
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public void rollback() throws IOException {
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public <T extends IStorable> IStorageSPI<T> createStorage(String alias, Class<T> type) throws IOException, CancelException {
        Properties config = StorageConfigParser.parse(this.properties, alias);
        if (config.isEmpty()) {
            InMemoryStorage<T> storage = new InMemoryStorage<T>(type);
            LogAPI.logWarning((String)("Storage '" + alias + "' not configured"));
            return storage;
        }
        IStorageProvider provider = new FileSystemStorageProvider(this.baseDir, alias, config.getProperty("content-type", "xml"));
        if (config.containsKey("security")) {
            List<String> securityFeatures = Arrays.asList(config.getProperty("security").split("\\s"));
            if (securityFeatures.contains("encrypted")) {
                provider = new CryptoStorageProvider(new Base64StorageProvider(provider));
            }
            if (securityFeatures.contains("signed")) {
                provider = new DigestStorageProvider(provider);
            }
        }
        StorageImpl<T> storage = new StorageImpl<T>(provider, this.loaderFactory.createLoader(type), this.saverFactory.createSaver(type), type);
        return storage;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void deleteStorage(StorageId storageId) throws IOException, CancelException {
        File[] files;
        FileSystemStorageProvider provider = new FileSystemStorageProvider(this.baseDir, storageId.getAlias(), null);
        provider.setOuterSpace(storageId.getOuterSpace());
        provider.setInnerSpace(storageId.getInnerSpace());
        File directory = provider.getUserDir();
        if (!directory.exists()) {
            return;
        }
        for (File file : directory.listFiles()) {
            file.delete();
        }
        while (!this.baseDir.equals(directory) && (files = directory.listFiles()).length == 0) {
            directory.delete();
            directory = directory.getParentFile();
        }
    }

    @Override
    public StorageId[] listStorages() throws IOException, CancelException {
        ArrayList<StorageId> storageIds = new ArrayList<StorageId>();
        LinkedList<File> queue = new LinkedList<File>();
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        if (this.baseDir.isDirectory()) {
            queue.addAll(Arrays.asList(this.baseDir.listFiles(dirFilter)));
            while (!queue.isEmpty()) {
                File dir = (File)queue.remove();
                boolean found = false;
                for (File file : dir.listFiles()) {
                    if (file.isDirectory()) {
                        queue.add(file);
                        continue;
                    }
                    if (found) continue;
                    found = true;
                    try {
                        FileSystemStorageProvider provider = new FileSystemStorageProvider(this.baseDir, dir, file.getName().substring(file.getName().lastIndexOf(46) + 1));
                        storageIds.add(new StorageId(provider.getAlias(), provider.getOuterSpace(), provider.getInnerSpace()));
                    }
                    catch (IOException e) {
                        LogAPI.logWarning((String)("Found some crap in the storage: " + file.getPath()));
                    }
                }
            }
        }
        return storageIds.toArray(new StorageId[0]);
    }

    @Override
    public boolean isSameLocation(IExtendedStorageFactorySPI factory) {
        if (factory instanceof FileStorageFactorySPI) {
            return this.baseDir.equals(((FileStorageFactorySPI)factory).baseDir);
        }
        return false;
    }

    @Override
    public boolean containsAnyData() throws IOException, CancelException {
        StorageId[] storageIds;
        for (StorageId storageId : storageIds = this.listStorages()) {
            IStorageSPI<RawRecord> storage = this.createStorage(storageId.getAlias(), RawRecord.class);
            storage.setOuterSpace(storageId.getOuterSpace());
            storage.setInnerSpace(storageId.getInnerSpace());
            String[] ids = storage.getIds();
            if (ids.length <= 0) continue;
            return true;
        }
        return false;
    }
}

