/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage;

import com.selima.fbi.CancelException;
import com.selima.fbi.loader.ILoader;
import com.selima.fbi.saver.ISaver;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.storage.IStorageSPI;
import com.selima.fbi.storage.Transaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StorageImpl<T extends IStorable>
implements IStorageSPI<T> {
    protected IStorageProvider storageProvider;
    protected ILoader<T> loader;
    protected ISaver saver;
    protected Class<T> type;
    protected String innerSpace;

    public StorageImpl(IStorageProvider storageProvider, ILoader<T> loader, ISaver saver, Class<T> type) {
        this.storageProvider = storageProvider;
        this.loader = loader;
        this.saver = saver;
        this.type = type;
    }

    @Override
    public void setInnerSpace(String space) {
        this.innerSpace = space;
        this.storageProvider.setInnerSpace(space);
    }

    @Override
    public void setOuterSpace(String space) {
        this.storageProvider.setOuterSpace(space);
    }

    @Override
    public String[] getIds() throws IOException, CancelException {
        return this.storageProvider.getIds();
    }

    @Override
    public boolean contains(String storeId) throws IOException, CancelException {
        return this.storageProvider.contains(storeId);
    }

    @Override
    public final void store(final T msg) throws IOException, CancelException {
        final String storeId = msg.getStoreId();
        if (storeId == null) {
            throw new IllegalArgumentException("missing storeId");
        }
        if (!this.equals(this.innerSpace, msg.getStoreSpace())) {
            throw new IllegalArgumentException("Invalid store-space:" + this.innerSpace + " is not " + msg.getStoreSpace());
        }
        new Transaction(this.storageProvider).run(new Transaction.InteractionR0<Void>(){

            @Override
            public Void run() throws IOException, CancelException {
                OutputStream out = StorageImpl.this.storageProvider.getOutputStream(storeId);
                try {
                    StorageImpl.this.saver.save(msg, out);
                }
                catch (IOException e) {
                    StorageImpl.this.checkCancelException(e);
                    throw e;
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        StorageImpl.this.checkCancelException(e);
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public T load(final String storeId) throws IOException, CancelException {
        return (T)((IStorable)new Transaction(this.storageProvider).run(new Transaction.InteractionR0<T>(){

            @Override
            public T run() throws IOException, CancelException {
                if (!StorageImpl.this.contains(storeId)) {
                    throw new IOException("Object '" + storeId + "' not stored.");
                }
                InputStream in = StorageImpl.this.storageProvider.getInputStream(storeId);
                try {
                    Object t = StorageImpl.this.loader.load(in);
                    return t;
                }
                catch (IOException e) {
                    StorageImpl.this.checkCancelException(e);
                    throw e;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        StorageImpl.this.checkCancelException(e);
                        throw e;
                    }
                }
            }
        }));
    }

    @Override
    public void delete(final String storeId) throws IOException, CancelException {
        new Transaction(this.storageProvider).run(new Transaction.InteractionR0<Void>(){

            @Override
            public Void run() throws IOException, CancelException {
                if (!StorageImpl.this.contains(storeId)) {
                    throw new IOException("Object '" + storeId + "' not stored.");
                }
                StorageImpl.this.storageProvider.delete(storeId);
                return null;
            }
        });
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public IStorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    private void checkCancelException(IOException e) throws CancelException {
        Throwable cause = e.getCause();
        if (cause instanceof CancelException) {
            throw (CancelException)cause;
        }
    }

    private boolean equals(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }
}

