/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.loader.LoaderFactory;
import com.selima.fbi.saver.SaverFactory;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.IStorageFactorySPI;
import com.selima.fbi.storage.IStorageSPI;
import com.selima.fbi.storage.file.FileStorageFactorySPI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StorageFactory
implements IStorageFactory {
    private final Map<StoreKey, IStorageSPI<?>> storages = new HashMap();
    private String outerSpace;
    private IStorageFactorySPI storageFactorySPI;

    public IStorageFactorySPI getStorageFactorySPI() {
        return this.storageFactorySPI;
    }

    public StorageFactory() {
        this(MailServiceConfig.getInitParamaters());
    }

    public StorageFactory(Map<String, String> parameters) {
        this(StorageFactory.createStorageFactorySPI(parameters));
    }

    private static IStorageFactorySPI createStorageFactorySPI(Map<String, String> parameters) {
        return new FileStorageFactorySPI(parameters, new LoaderFactory(), new SaverFactory());
    }

    public StorageFactory(IStorageFactorySPI storageFactorySPI) {
        this.storageFactorySPI = storageFactorySPI;
    }

    @Override
    public String getName() {
        return this.storageFactorySPI.getName();
    }

    @Override
    public void setOuterSpace(String outerSpace) {
        this.outerSpace = outerSpace;
        for (IStorageSPI<?> storage : this.storages.values()) {
            storage.setOuterSpace(outerSpace);
        }
    }

    @Override
    public final <T extends IStorable> IStorage<T> getStorage(String alias, Class<T> storedType) throws IOException, CancelException {
        return this.getStorage(alias, null, storedType);
    }

    @Override
    public final <T extends IStorable> IStorage<T> getStorage(String alias, String innerSpace, Class<T> storedType) throws IOException, CancelException {
        StoreKey key = new StoreKey(alias, innerSpace);
        IStorage existing = this.storages.get(key);
        if (existing != null) {
            if (existing.getType() != storedType) {
                throw new IllegalArgumentException("Storage '" + alias + "' instantiated for " + existing.getType() + " not " + storedType);
            }
            return existing;
        }
        IStorageSPI<T> created = this.storageFactorySPI.createStorage(alias, storedType);
        created.setInnerSpace(innerSpace);
        created.setOuterSpace(this.outerSpace);
        this.storages.put(key, created);
        return created;
    }

    <T extends IStorable> void setStorage(String alias, String innerSpace, IStorageSPI<T> storage) throws IOException {
        this.storages.put(new StoreKey(alias, innerSpace), storage);
    }

    @Override
    public void begin() throws IOException, CancelException {
        this.storageFactorySPI.begin();
    }

    @Override
    public void commit() throws IOException, CancelException {
        this.storageFactorySPI.commit();
    }

    @Override
    public void rollback() throws IOException, CancelException {
        this.storageFactorySPI.rollback();
    }

    @Override
    public boolean isInTransaction() {
        return this.storageFactorySPI.isInTransaction();
    }

    @Override
    public void cancel() {
        this.storageFactorySPI.cancel();
    }

    protected void resetTypeInformation() {
        this.storages.clear();
    }

    static class StoreKey {
        String alias;
        String space;

        StoreKey(String alias, String space) {
            this.alias = alias;
            this.space = space;
        }

        public boolean equals(Object obj) {
            StoreKey key = (StoreKey)obj;
            return this.equals(this.alias, key.alias) && this.equals(this.space, key.space);
        }

        public int hashCode() {
            return this.hashCode(this.alias) + this.hashCode(this.space);
        }

        private boolean equals(Object o1, Object o2) {
            return o1 != null ? o1.equals(o2) : o2 == null;
        }

        private int hashCode(Object o) {
            return o != null ? o.hashCode() : 0;
        }

        public String toString() {
            return this.alias + "," + this.space;
        }
    }
}

