/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.service.AbstractMailService;
import com.selima.fbi.service.Axis2DPSErrorTranslator;
import com.selima.fbi.service.AxisSAMLTokenProvider;
import com.selima.fbi.service.AxisSocketClosingClient;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.FailedConnectDpsAuthenticationClient;
import com.selima.fbi.service.FailedConnectDpsClient;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.soap.AxisServiceWithHTTPCustomization;
import com.selima.fbi.soap.AxisServiceWithSAMLToken;
import com.selima.fbi.soap.AxisServiceWithUserNameToken;
import com.selima.fbi.soap.AxisStubForHTMLForms;
import com.selima.fbi.soap.AxisStubWithLog4J;
import com.selima.fbi.soap.ICredentialsOwner;
import com.selima.fbi.soap.ISAMLTokenOwner;
import com.selima.fbi.soap.dps.live.DPSdata;
import com.selima.fbi.soap.dps.live.Dps;
import com.selima.fbi.soap.dps.live.DpsLocator;
import com.selima.fbi.soap.dps.live.DpsSoap;
import com.selima.fbi.soap.dps.live.Dpsauthentication;
import com.selima.fbi.soap.dps.live.DpsauthenticationLocator;
import com.selima.fbi.soap.dps.live.DpsauthenticationSoap;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.types.NonNegativeInteger;
import org.w3c.dom.Element;

public class LiveMailService
extends AbstractMailService {
    @Override
    public void init(Map<String, String> parameters) throws MailServiceException {
        super.init(parameters);
        HMRCMark.setTrustedKeyStore("live-hmrcmark-cert.jks", "password");
    }

    @Override
    public IDpsClient createDpsClient(ISAMLTokenOwner samlOwner) throws MailServiceException {
        DpsSoap rawDpsSoap;
        DpsSoap wssDpsSoap;
        Dps wssDps = AxisServiceWithSAMLToken.createService(DpsLocator.class, Dps.class);
        Dps rawDps = AxisServiceWithHTTPCustomization.createService(DpsLocator.class, Dps.class);
        try {
            if (this.dpsUrl != null) {
                wssDpsSoap = wssDps.getdpsSoap(new URL(this.dpsUrl));
                rawDpsSoap = rawDps.getdpsSoap(new URL(this.dpsUrl));
            } else {
                wssDpsSoap = wssDps.getdpsSoap();
                rawDpsSoap = rawDps.getdpsSoap();
            }
        }
        catch (MalformedURLException e) {
            throw new MailServiceException(e);
        }
        catch (ServiceException e) {
            throw new MailServiceException(e);
        }
        wssDpsSoap = AxisStubForHTMLForms.wrapStub(wssDpsSoap, DpsSoap.class);
        rawDpsSoap = AxisStubForHTMLForms.wrapStub(rawDpsSoap, DpsSoap.class);
        DpsSoap dpsSoap = AxisSAMLTokenProvider.wrapStub(wssDpsSoap, rawDpsSoap, DpsSoap.class, samlOwner);
        dpsSoap = Axis2DPSErrorTranslator.wrapStub(dpsSoap, DpsSoap.class);
        if (this.logEnabled) {
            dpsSoap = AxisStubWithLog4J.wrapStub(dpsSoap, DpsSoap.class, this.loggerDir);
        }
        return new FailedConnectDpsClient(new LiveDpsClient(dpsSoap));
    }

    @Override
    public IDpsAuthenticationClient createDpsAuthenticationClient(ICredentialsOwner credentialsOwner) throws MailServiceException {
        DpsauthenticationSoap authSoap;
        Dpsauthentication auth = AxisServiceWithUserNameToken.createService(DpsauthenticationLocator.class, Dpsauthentication.class, credentialsOwner);
        try {
            authSoap = this.authenticationUrl != null ? auth.getdpsauthenticationSoap(new URL(this.authenticationUrl)) : auth.getdpsauthenticationSoap();
        }
        catch (MalformedURLException e) {
            throw new MailServiceException(e);
        }
        catch (ServiceException e) {
            throw new MailServiceException(e);
        }
        authSoap = AxisStubForHTMLForms.wrapStub(authSoap, DpsauthenticationSoap.class);
        authSoap = Axis2DPSErrorTranslator.wrapStub(authSoap, DpsauthenticationSoap.class);
        if (this.logEnabled) {
            authSoap = AxisStubWithLog4J.wrapStub(authSoap, DpsauthenticationSoap.class, this.loggerDir);
        }
        return new FailedConnectDpsAuthenticationClient(new LiveDpsAuthenticationClient(authSoap));
    }

    @Override
    public PluginType getDefaultPluginType() {
        return PluginType.live;
    }

    static class LiveDpsAuthenticationClient
    extends AxisSocketClosingClient
    implements IDpsAuthenticationClient {
        DpsauthenticationSoap authSoap;

        LiveDpsAuthenticationClient(DpsauthenticationSoap authSoap) {
            this.authSoap = authSoap;
        }

        @Override
        public String DPSrequestToken(int version, String vendorID) throws DPSException, RemoteException, CancelException {
            try {
                return this.authSoap.DPSrequestToken(version, vendorID);
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }
    }

    static class LiveDpsClient
    extends AxisSocketClosingClient
    implements IDpsClient {
        DpsSoap dpsSoap;

        LiveDpsClient(DpsSoap dpsSoap) {
            this.dpsSoap = dpsSoap;
        }

        @Override
        public long DPSretrieve(int version, String vendorID, String service, String entityType, String entity, String dataType, long got, int nItems, List<Element> data) throws CancelException, DPSException, RemoteException {
            try {
                DPSdata result = this.dpsSoap.DPSretrieve(version, vendorID, service, entityType, entity, dataType, new NonNegativeInteger(Long.toString(got)), new NonNegativeInteger(Integer.toString(nItems)));
                if (result.get_any() != null) {
                    data.addAll(Arrays.asList(result.get_any()));
                }
                return Math.max(got, result.getDPSheader().getHighWaterMark().longValue());
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }

        @Override
        public int DPSquery(int version, String vendorID, String service, String entityType, String entity, String dataType, long got) throws CancelException, DPSException, RemoteException {
            try {
                return (int)this.dpsSoap.DPSquery(version, vendorID, service, entityType, entity, dataType, new NonNegativeInteger(Long.toString(got)));
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }

        @Override
        public long DPSdate2Index(int version, String vendorID, String service, String entityType, String entity, String dataType, Calendar date) throws CancelException, DPSException, RemoteException {
            try {
                return this.dpsSoap.DPSdate2Index(version, vendorID, service, entityType, entity, dataType, date == null ? null : date.getTime());
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }
    }
}

