/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.service.FakeAuthenticationClient;
import com.selima.fbi.service.FakeDpsClient;
import com.selima.fbi.service.FakeServiceContextImpl;
import com.selima.fbi.service.FakeSubmissionContext;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IFakeServiceContext;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.soap.ICredentialsOwner;
import com.selima.fbi.soap.ISAMLTokenOwner;
import com.selima.fbi.submission.IStaticSubmissionContext;
import java.util.Map;

public class FakeMailService
implements IMailService {
    Map<String, String> parameters;
    IFakeServiceContext context;

    public FakeMailService() {
        this(new FakeServiceContextImpl());
    }

    public FakeMailService(IFakeServiceContext context) {
        this.context = context;
    }

    @Override
    public void init(Map<String, String> parameters) throws MailServiceException {
        this.parameters = parameters;
        HMRCMark.setTrustedKeyStore("fakecert.jks", "password");
    }

    @Override
    public IDpsClient createDpsClient(ISAMLTokenOwner samlOwner) throws MailServiceException {
        return new FakeDpsClient(samlOwner, this.context);
    }

    @Override
    public IDpsAuthenticationClient createDpsAuthenticationClient(ICredentialsOwner credentialsOwner) throws MailServiceException {
        return new FakeAuthenticationClient(credentialsOwner, this.context);
    }

    @Override
    public IStaticSubmissionContext createSubmissionContext() {
        return new FakeSubmissionContext();
    }

    @Override
    public PluginType getDefaultPluginType() {
        return PluginType.memory;
    }

    @Override
    public String getAlias() {
        return this.parameters == null ? "fake" : this.parameters.get("alias");
    }
}

