/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.service.IFakeDatabase;
import com.selima.fbi.service.IFakeDatabaseIterator;
import com.selima.fbi.service.fakes.Fake;
import com.selima.fbi.service.fakes.IFake;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.Random;

public class FakeDatabaseImpl
implements IFakeDatabase {
    static final Calendar DAY_ZERO = new GregorianCalendar(2006, 1, 22);
    static final Record[] RECORDS = new Record[1024];
    static final String[] EMPREFS = new String[]{"123/AN64312", "123/1739465", "123/A6"};
    static final long MILLISECONDS_PER_DAY = 86400000L;
    Record[] records;
    Calendar dayZero;
    Calendar frozenTime;

    public FakeDatabaseImpl() {
        this(DAY_ZERO);
    }

    FakeDatabaseImpl(Calendar dayZero) {
        this.dayZero = dayZero;
        this.records = RECORDS;
    }

    @Override
    public IFakeDatabaseIterator retrieve(String employer, String type, long got, int count) {
        return new FakeIterator(employer, type, got, count);
    }

    @Override
    public long data2index(String employer, String type, Calendar calendar) {
        if (calendar.after(this.dayZero)) {
            long got = this.toGot(calendar);
            got = got / (long)this.records.length * (long)this.records.length;
            long tries = this.records.length;
            while (tries > 0L) {
                Record record = this.records[(int)(got % (long)this.records.length)];
                if (record.match(employer, type)) {
                    return got;
                }
                --tries;
                --got;
            }
        }
        return 0L;
    }

    public void freezeTime() {
        this.frozenTime = new GregorianCalendar();
    }

    Calendar toDate(long got) {
        long dif = got * 86400000L / (long)this.records.length;
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(this.dayZero.getTimeInMillis() + dif);
        return result;
    }

    long toGot(Calendar date) {
        long dif = date.getTimeInMillis() - this.dayZero.getTimeInMillis();
        return dif * (long)this.records.length / 86400000L;
    }

    long currentGot() {
        Calendar now = this.frozenTime != null ? this.frozenTime : new GregorianCalendar();
        return this.toGot(now);
    }

    long lowerBoundGot() {
        return Math.max(0L, this.currentGot() - (long)(2 * this.records.length));
    }

    static {
        Random r = new Random(0L);
        Fake[] fakes = Fake.values();
        for (int i = 0; i < RECORDS.length; ++i) {
            String emp = EMPREFS[r.nextInt(EMPREFS.length)];
            Fake fake = fakes[r.nextInt(fakes.length)];
            FakeDatabaseImpl.RECORDS[i] = new Record(emp, fake);
        }
    }

    class FakeIterator
    implements IFakeDatabaseIterator {
        boolean beforeFirstRecord = true;
        Record nextRecord;
        String employer;
        String type;
        long got;
        long actual;
        long last;
        long count;

        FakeIterator(String employer, String type, long got, long count) {
            this.type = type;
            this.employer = employer;
            this.count = count;
            this.got = got;
            this.last = FakeDatabaseImpl.this.currentGot();
            this.actual = Math.max(got, FakeDatabaseImpl.this.lowerBoundGot());
        }

        @Override
        public boolean hasNext() {
            if (this.nextRecord == null) {
                this.nextRecord = this.findNextRecord();
            }
            return this.nextRecord != null;
        }

        @Override
        public String next() {
            try {
                if (this.nextRecord == null) {
                    this.nextRecord = this.findNextRecord();
                }
                if (this.nextRecord == null) {
                    throw new NoSuchElementException();
                }
                String string = this.nextRecord.fake.template(this.nextRecord.empRef, this.actual);
                return string;
            }
            finally {
                this.nextRecord = null;
                this.beforeFirstRecord = false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSequenceNumber() {
            return this.beforeFirstRecord ? this.got : this.actual;
        }

        private Record findNextRecord() {
            while (this.actual < this.last && this.count > 0L) {
                ++this.actual;
                Record record = FakeDatabaseImpl.this.records[(int)(this.actual % (long)FakeDatabaseImpl.this.records.length)];
                if (!record.match(this.employer, this.type)) continue;
                --this.count;
                return record;
            }
            return null;
        }
    }

    static class Record {
        String empRef;
        IFake fake;

        Record(String empRef, IFake fake) {
            this.empRef = empRef;
            this.fake = fake;
        }

        boolean match(String empRef, String type) {
            return this.empRef.equals(empRef) && this.fake.dataType().name().equals(type);
        }
    }
}

