/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.service.DPSErrorEnum;
import java.rmi.RemoteException;

public class DPSException
extends RemoteException {
    DPSErrorEnum[] errors;
    String[] descriptions;

    public DPSException(Throwable cause, DPSErrorEnum[] errors, String[] descriptions) {
        super(DPSException.createErrorMessage(descriptions), cause);
        this.errors = errors;
        this.descriptions = descriptions;
    }

    public DPSException(DPSErrorEnum error) {
        super(error.toString());
        this.errors = new DPSErrorEnum[]{error};
        this.descriptions = new String[]{error.getNote()};
    }

    public DPSErrorEnum[] getDPSErrors() {
        return this.errors;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public boolean isType(DPSErrorEnum error) {
        for (DPSErrorEnum e : this.errors) {
            if (e != error) continue;
            return true;
        }
        return false;
    }

    private static String createErrorMessage(String[] descriptions) {
        StringBuilder result = new StringBuilder();
        if (descriptions.length > 0) {
            result.append(descriptions[0]);
            for (int i = 1; i < descriptions.length; ++i) {
                result.append(' ').append(descriptions[i]);
            }
        }
        return result.toString();
    }
}

