/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.sender;

import com.selima.fbi.CancelException;
import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.sender.ISenderDetails;
import com.selima.fbi.sender.ISenderDetailsManager;
import com.selima.fbi.sender.ISenderDetailsSource;
import com.selima.fbi.sender.SenderDetailsImpl;
import com.selima.fbi.sender.StorableID;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import java.io.IOException;

public class SenderDetailsManagerImpl
implements ISenderDetailsManager,
ISenderDetailsSource {
    private IStorageFactory storageFactory;
    private IStorage<SenderDetailsImpl> detailsStorage;
    private IStorage<StorableID> defaultStorage;

    public SenderDetailsManagerImpl(IStorageFactory storageFactory) throws IOException, CancelException {
        this.storageFactory = storageFactory;
        this.detailsStorage = storageFactory.getStorage("sender-details", SenderDetailsImpl.class);
        this.defaultStorage = storageFactory.getStorage("default-sender", StorableID.class);
    }

    @Override
    public ISenderDetails getSenderDetailsForEmpRef(final String empRef) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<ISenderDetails>(){

            @Override
            public ISenderDetails run() throws IOException, CancelException {
                for (String id : SenderDetailsManagerImpl.this.detailsStorage.getIds()) {
                    IModifiableSenderDetails details = SenderDetailsManagerImpl.this.load(id);
                    if (!details.getAllEmpRefs().contains(empRef)) continue;
                    return details;
                }
                return SenderDetailsManagerImpl.this.getDefault();
            }
        });
    }

    @Override
    public void delete(String id) throws IOException, CancelException {
        this.detailsStorage.delete(id);
    }

    @Override
    public IModifiableSenderDetails load(String id) throws IOException, CancelException {
        SenderDetailsImpl senderDetails = this.detailsStorage.load(id);
        senderDetails.setStoreId(id);
        return senderDetails;
    }

    @Override
    public void store(final IModifiableSenderDetails senderDetails) throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                if (senderDetails.getStoreId() == null) {
                    senderDetails.setStoreId(SenderDetailsManagerImpl.this.generateUniqueId());
                }
                SenderDetailsManagerImpl.this.detailsStorage.store((SenderDetailsImpl)senderDetails);
            }
        });
    }

    private String generateUniqueId() throws IOException, CancelException {
        int i = 1;
        String idCandidate;
        while (this.detailsStorage.contains(idCandidate = "Sender " + i)) {
            ++i;
        }
        return idCandidate;
    }

    @Override
    public String[] getIds() throws IOException, CancelException {
        return this.detailsStorage.getIds();
    }

    public IStorage<SenderDetailsImpl> getStorage() {
        return this.detailsStorage;
    }

    @Override
    public IModifiableSenderDetails create() {
        return new SenderDetailsImpl();
    }

    @Override
    public IModifiableSenderDetails getDefault() throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<IModifiableSenderDetails>(){

            @Override
            public IModifiableSenderDetails run() throws IOException, CancelException {
                if (SenderDetailsManagerImpl.this.defaultStorage.contains("default")) {
                    StorableID id = (StorableID)SenderDetailsManagerImpl.this.defaultStorage.load("default");
                    if (SenderDetailsManagerImpl.this.detailsStorage.contains(id.toString())) {
                        return (IModifiableSenderDetails)SenderDetailsManagerImpl.this.detailsStorage.load(id.toString());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void setDefault(final IModifiableSenderDetails details) throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                if (details == null) {
                    if (SenderDetailsManagerImpl.this.defaultStorage.contains("default")) {
                        SenderDetailsManagerImpl.this.defaultStorage.delete("default");
                    }
                } else {
                    if (details.getStoreId() == null) {
                        details.setStoreId(SenderDetailsManagerImpl.this.generateUniqueId());
                    }
                    StorableID id = new StorableID(details.getStoreId());
                    id.setStoreId("default");
                    SenderDetailsManagerImpl.this.defaultStorage.store(id);
                }
            }
        });
    }
}

