/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import com.selima.fbi.plugin.PluginException;

class UniverseVersion
implements Comparable<UniverseVersion> {
    int major;
    int minor;
    int bugfix;

    UniverseVersion(String value) throws PluginException {
        String[] split = value.split("\\.");
        switch (split.length) {
            case 3: 
            case 4: {
                this.bugfix = Integer.parseInt(split[2]);
            }
            case 2: {
                this.minor = Integer.parseInt(split[1]);
            }
            case 1: {
                this.major = Integer.parseInt(split[0]);
                break;
            }
            default: {
                throw new PluginException("Unable to recognize version of Universe: " + value);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UniverseVersion) {
            UniverseVersion other = (UniverseVersion)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    boolean equalOrAfter(UniverseVersion version) {
        return this.compareTo(version) >= 0;
    }

    boolean equalOrBefore(UniverseVersion version) {
        return this.compareTo(version) <= 0;
    }

    boolean after(UniverseVersion version) {
        return this.compareTo(version) > 0;
    }

    boolean before(UniverseVersion version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public int compareTo(UniverseVersion o) {
        int result = this.major - o.major;
        if (result == 0) {
            result = this.minor - o.minor;
        }
        if (result == 0) {
            result = this.major - o.major;
        }
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }
}

