/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringTokenizer;
import asjava.uniclientlibs.UniTokens;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSession;
import com.selima.fbi.CancelException;
import com.selima.fbi.core.GenderEnum;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.PayrollDataFormatException;
import com.selima.fbi.plugin.u2.UniverseExecutionImpl;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import com.selima.fbi.plugin.u2.UniverseVersion;
import com.selima.framework.util.logging.LogAPI;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class UniverseRecordImpl
implements UniverseRecord {
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    final String id;
    final UniFile uniFile;
    final UniSession uniSession;
    final UniverseExecutionImpl.UniverseSessionImpl universeSession;

    UniverseRecordImpl(UniverseExecutionImpl.UniverseSessionImpl universeSession, UniSession uniSession, UniFile uniFile, String id) {
        this.universeSession = universeSession;
        this.uniSession = uniSession;
        this.uniFile = uniFile;
        this.id = id;
    }

    @Override
    public String readString(String column) throws UniverseRPCException, CancelException, PluginException {
        UniString field = this.readNamedField(column);
        return field.toString().length() > 0 ? field.toString() : null;
    }

    @Override
    public List<String> readStrings(String ... columns) throws UniverseRPCException, CancelException, PluginException {
        ArrayList<String> result = new ArrayList<String>(columns.length);
        for (String column : columns) {
            String value = this.readString(column);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public List<String> readMultivaluedStrings(String column) throws UniverseRPCException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseMultivaluedStrings(value);
    }

    @Override
    public String readString(String column, int index) throws UniverseRPCException, CancelException, PluginException {
        String[] parts;
        String result = this.readString(column);
        if (result != null && (parts = result.split("\\s", index + 2)).length > index && parts[index].length() > 0) {
            return parts[index];
        }
        return null;
    }

    @Override
    public Number readNumber(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseNumber(column, value);
    }

    @Override
    public String readFormattedNumber(String column, String format) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        Number number = this.readNumber(column);
        if (number != null) {
            return new DecimalFormat(format).format(number);
        }
        return null;
    }

    @Override
    public Date readDate(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        String field = this.readString(column);
        return this.parseDate(column, field);
    }

    @Override
    public List<Number> readMultivaluedNumbers(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseMultivaluedNumbers(column, value);
    }

    @Override
    public List<Date> readMultivaluedDates(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseMultivaluedDates(column, value);
    }

    @Override
    public List<Integer> readMultivaluedIntegers(String column) throws UniverseRPCException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseMultivaluedIntegers(column, value);
    }

    @Override
    public List<YesNoEnum> readMultivaluedYesNo(String column) throws UniverseRPCException, CancelException, PluginException {
        String value = this.readString(column);
        return this.parseMultivaluedYesNo(column, value);
    }

    void logFinest(String message) {
        LogAPI.logFinest((String)message);
    }

    private List<String> parseMultivaluedStrings(String value) {
        ArrayList<String> result = new ArrayList<String>();
        UniStringTokenizer tokenizer = new UniStringTokenizer((Object)value, (Object)UniTokens.VM_CHAR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.add(token.length() > 0 ? token : null);
        }
        return result;
    }

    private List<YesNoEnum> parseMultivaluedYesNo(String column, String value) throws PayrollDataFormatException {
        String parsedString2 = null;
        try {
            List<String> strings = this.parseMultivaluedStrings(value);
            ArrayList<YesNoEnum> results = new ArrayList<YesNoEnum>(strings.size());
            for (String parsedString2 : strings) {
                if (parsedString2 != null) {
                    results.add(YesNoEnum.valueOf(parsedString2));
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        catch (NumberFormatException e) {
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, parsedString2);
        }
    }

    private List<Integer> parseMultivaluedIntegers(String column, String value) throws PayrollDataFormatException {
        String parsedString2 = null;
        try {
            List<String> strings = this.parseMultivaluedStrings(value);
            ArrayList<Integer> results = new ArrayList<Integer>(strings.size());
            for (String parsedString2 : strings) {
                if (parsedString2 != null) {
                    results.add(Integer.parseInt(parsedString2));
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        catch (NumberFormatException e) {
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, parsedString2);
        }
    }

    private List<Number> parseMultivaluedNumbers(String column, String value) throws PayrollDataFormatException {
        String parsedString2 = null;
        try {
            List<String> strings = this.parseMultivaluedStrings(value);
            ArrayList<Number> results = new ArrayList<Number>(strings.size());
            for (String parsedString2 : strings) {
                if (parsedString2 != null) {
                    results.add(new BigDecimal(parsedString2));
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        catch (NumberFormatException e) {
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, parsedString2);
        }
    }

    private Number parseNumber(String column, String value) throws PayrollDataFormatException {
        if (value != null) {
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, value);
            }
        }
        return null;
    }

    private List<Date> parseMultivaluedDates(String column, String value) throws PayrollDataFormatException {
        String parsedString2 = null;
        try {
            List<String> strings = this.parseMultivaluedStrings(value);
            ArrayList<Date> results = new ArrayList<Date>(strings.size());
            for (String parsedString2 : strings) {
                if (parsedString2 != null) {
                    results.add(this.dateFormat.parse(parsedString2));
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        catch (ParseException e) {
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, parsedString2);
        }
    }

    private Date parseDate(String column, String value) throws PayrollDataFormatException {
        if (value != null) {
            try {
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, value);
            }
        }
        return null;
    }

    private UniString readNamedField(String column) throws PluginException, CancelException {
        try {
            this.universeSession.checkCancel();
            if (this.universeSession.serverVersion().equalOrBefore(new UniverseVersion("10.0.0"))) {
                this.logFinest("file(" + this.uniFile.getFileName() + ").record(" + this.id + ").iType(" + column + ")");
                return this.uniFile.iType((Object)this.id, (Object)column);
            }
            this.uniFile.setRecordID((Object)this.id);
            this.logFinest("file(" + this.uniFile.getFileName() + ").record(" + this.id + ").read-column(" + column + ")");
            return this.uniFile.readNamedField((Object)column);
        }
        catch (UniFileException e) {
            switch (e.getErrorCode()) {
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException(e);
                }
            }
            this.universeSession.checkInterrupt(e);
            if (this.uniSession.getRPCError()) {
                throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
            }
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            this.universeSession.checkInterrupt(e);
            throw e;
        }
    }

    @Override
    public GenderEnum readGender(String column) throws UniverseRPCException, CancelException, PayrollDataFormatException, PluginException {
        String value = this.readString(column);
        try {
            return GenderEnum.valueOfString(value);
        }
        catch (IllegalArgumentException e) {
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, value);
        }
    }
}

