/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSelectList;
import asjava.uniobjects.UniSelectListException;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseExecution2Impl;
import com.selima.fbi.plugin.u2.UniverseFileType19;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import java.util.ArrayList;
import java.util.List;

class UniverseFileType19Impl
implements UniverseFileType19 {
    UniFile file;
    UniSession uniSession;
    UniverseExecution2Impl.UniverseSessionImpl2 parentSession;

    UniverseFileType19Impl(UniverseExecution2Impl.UniverseSessionImpl2 parentSession, UniSession uniSession, UniFile file) throws CancelException, PluginException {
        this.parentSession = parentSession;
        this.uniSession = uniSession;
        this.file = file;
    }

    @Override
    public void delete(String id) throws PluginException, CancelException {
        try {
            this.parentSession.checkCancel();
            this.file.deleteRecord((Object)id);
        }
        catch (UniFileException e) {
            this.parentSession.resolveFileIOError(e);
        }
        catch (RuntimeException e) {
            this.parentSession.checkInterrupt(e);
            throw e;
        }
    }

    @Override
    public List<String> list() throws PluginException, CancelException {
        try {
            UniSelectList list = this.uniSession.selectList(1);
            list.select(this.file);
            UniDynArray ids = list.readList();
            ArrayList<String> result = new ArrayList<String>(ids.dcount());
            for (int i = 1; i <= ids.dcount(); ++i) {
                result.add(ids.extract(i).toString());
            }
            return result;
        }
        catch (UniSessionException e) {
            switch (e.getErrorCode()) {
                case 39120: {
                    this.parentSession.checkInterrupt(e);
                }
            }
            throw new IllegalStateException(e);
        }
        catch (UniSelectListException e) {
            switch (e.getErrorCode()) {
                case 30114: {
                    throw new IllegalStateException(e);
                }
            }
            this.parentSession.checkInterrupt(e);
            if (this.uniSession.getRPCError()) {
                throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }
        catch (RuntimeException e) {
            this.parentSession.checkInterrupt(e);
            throw e;
        }
    }

    @Override
    public void write(String id, String record) throws CancelException, PluginException {
        try {
            this.parentSession.checkCancel();
            this.file.write((Object)id, (Object)record);
        }
        catch (UniFileException e) {
            this.parentSession.resolveFileIOError(e);
        }
        catch (RuntimeException e) {
            this.parentSession.checkInterrupt(e);
            throw e;
        }
    }
}

