/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniTokens;
import asjava.uniobjects.UniCommand;
import asjava.uniobjects.UniCommandException;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniJava;
import asjava.uniobjects.UniSelectList;
import asjava.uniobjects.UniSelectListException;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import asjava.uniobjects.UniSubroutine;
import asjava.uniobjects.UniSubroutineException;
import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.NonExistingAccountException;
import com.selima.fbi.plugin.u2.PayrollErrorException;
import com.selima.fbi.plugin.u2.StringHolder;
import com.selima.fbi.plugin.u2.SubroutineException;
import com.selima.fbi.plugin.u2.TaskLockException;
import com.selima.fbi.plugin.u2.UniverseExecution;
import com.selima.fbi.plugin.u2.UniverseFile;
import com.selima.fbi.plugin.u2.UniverseFileImpl;
import com.selima.fbi.plugin.u2.UniverseFileNotFoundException;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseSession;
import com.selima.fbi.plugin.u2.UniverseVersion;
import com.selima.fbi.plugin.u2.UniverseWork;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.fbi.util.ReflectionUtil;
import com.selima.framework.util.logging.LogAPI;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class UniverseExecutionImpl
implements UniverseExecution {
    static int INTERRUPT_TIMEOUT = 2500;
    static int NUMBER_OF_RETRY_ATTEMPTS = 10;
    private static UniJava uniJava = new UniJava();
    protected volatile UniSession uniSession;
    private volatile boolean cancel;
    private volatile boolean interrupt;
    private Timer interruptTimer;
    private final PayrollServerSpec payrollServer;
    private volatile TimerTask interruptTask;
    private Thread connectingThread;
    private final boolean autodisconnect;
    private static Map<String, UniverseVersion> versions = new HashMap<String, UniverseVersion>();

    public UniverseExecutionImpl(PayrollServerSpec payrollServer) {
        this.payrollServer = payrollServer;
        this.autodisconnect = true;
    }

    public UniverseExecutionImpl(PayrollServerSpec payrollServer, boolean autodisconnect) {
        this.payrollServer = payrollServer;
        this.autodisconnect = autodisconnect;
    }

    public void clearTaskLock(int lockNumber) throws PluginException, CancelException {
        try {
            if (this.uniSession == null) {
                this.connect();
            }
            this.releaseTaskLock(lockNumber);
        }
        catch (UniSessionException e) {
            this.handleUniSessionError(e);
            throw new PluginException(e);
        }
        catch (RuntimeException e) {
            this.checkInterrupt(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <ReturnType> ReturnType run(UniverseWork<ReturnType> universeWork) throws PluginException, CancelException {
        ReturnType ReturnType;
        boolean holdingLock = false;
        Integer lockNumber = this.payrollServer.getTaskLock();
        try {
            this.checkCancel();
            UniverseSessionImpl universeSession = new UniverseSessionImpl();
            if (this.uniSession == null) {
                this.connect();
                this.uniSession.setDefaultBlockingStrategy(1);
                this.checkCancel();
                universeSession.executeCommand("DATE.FORMAT");
                this.checkCancel();
                universeSession.executeCommand("LONGNAMES ON");
            }
            this.checkCancel();
            if (lockNumber != null) {
                this.obtainTaskLock(lockNumber);
                holdingLock = true;
            }
            ReturnType = universeWork.execute(universeSession);
        }
        catch (UniSessionException e) {
            try {
                this.handleUniSessionError(e);
                throw new PluginException(e);
                catch (RuntimeException e2) {
                    this.checkInterrupt(e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                try {
                    block25: {
                        if (!holdingLock) throw throwable;
                        boolean wasInterrupt = this.cancel && this.scheduleInterrupt(INTERRUPT_TIMEOUT);
                        try {
                            if (wasInterrupt) {
                                this.connect();
                            }
                            this.releaseTaskLock(lockNumber);
                            holdingLock = false;
                        }
                        catch (Exception releaseLockError) {
                            if (this.interrupt) break block25;
                            try {
                                this.logSevere(releaseLockError);
                                this.connect();
                                this.releaseTaskLock(lockNumber);
                                holdingLock = false;
                                this.logFine("Release TaskLock " + lockNumber + " error resolved");
                            }
                            catch (Exception e3) {
                                if (this.interrupt) break block25;
                                this.logSevere(e3);
                            }
                        }
                    }
                    if (!holdingLock) throw throwable;
                    this.logSevere("Despite all efforts unable to clear the TaskLock " + lockNumber + " " + (this.interrupt ? "(interrupted)" : ""));
                    throw throwable;
                }
                finally {
                    this.cancelInterrupt();
                    if (this.autodisconnect) {
                        this.disconnect();
                    }
                    this.cancel = false;
                }
            }
        }
        try {
            block26: {
                if (!holdingLock) return ReturnType;
                boolean wasInterrupt = this.cancel && this.scheduleInterrupt(INTERRUPT_TIMEOUT);
                try {
                    if (wasInterrupt) {
                        this.connect();
                    }
                    this.releaseTaskLock(lockNumber);
                    holdingLock = false;
                }
                catch (Exception releaseLockError) {
                    if (this.interrupt) break block26;
                    try {
                        this.logSevere(releaseLockError);
                        this.connect();
                        this.releaseTaskLock(lockNumber);
                        holdingLock = false;
                        this.logFine("Release TaskLock " + lockNumber + " error resolved");
                    }
                    catch (Exception e) {
                        if (this.interrupt) break block26;
                        this.logSevere(e);
                    }
                }
            }
            if (!holdingLock) return ReturnType;
            this.logSevere("Despite all efforts unable to clear the TaskLock " + lockNumber + " " + (this.interrupt ? "(interrupted)" : ""));
            return ReturnType;
        }
        finally {
            this.cancelInterrupt();
            if (this.autodisconnect) {
                this.disconnect();
            }
            this.cancel = false;
        }
    }

    private void handleUniSessionError(UniSessionException e) throws PluginException, NonExistingAccountException, CancelException, UniverseRPCException {
        String payrollName = this.payrollName();
        switch (e.getErrorCode()) {
            case 14022: 
            case 30098: 
            case 30114: 
            case 40003: {
                throw new IllegalStateException(e);
            }
            case 81011: {
                throw new PluginException("Unknown host <b>" + this.payrollServer.getHost() + "</b>");
            }
            case 80019: {
                throw new PluginException("Bad Password for " + payrollName);
            }
            case 80011: {
                throw new PluginException("Bad Login-name '" + this.payrollServer.getUser() + "' for " + payrollName);
            }
            case 39134: {
                throw new PluginException(e.getMessage() + ' ' + payrollName, e);
            }
            case 39125: 
            case 39129: {
                throw new NonExistingAccountException("Bad Account for " + payrollName, e);
            }
        }
        this.checkInterrupt(e);
        if (this.uniSession.getRPCError()) {
            throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.logFine("Canceling Universe execution");
        this.scheduleInterrupt(INTERRUPT_TIMEOUT);
    }

    void checkCancel() throws CancelException {
        if (this.cancel) {
            this.logFine("Cancel was gentle, no interrupt necessary");
            throw new CancelException();
        }
    }

    private void logFine(String message) {
        LogAPI.logFine((String)message);
    }

    private void logFiner(String message) {
        LogAPI.logFiner((String)message);
    }

    private void logSevere(String message) {
        LogAPI.logSevere((String)message);
    }

    private void logSevere(Throwable tw) {
        LogAPI.logSevere((Throwable)tw);
    }

    void checkInterrupt(Throwable cause) throws CancelException {
        if (this.interrupt) {
            this.logFine("Forced close caused " + cause);
            throw new CancelException(cause);
        }
    }

    private synchronized void cancelInterrupt() {
        if (this.interruptTimer != null) {
            this.interruptTimer.cancel();
            this.interruptTimer = null;
            this.interruptTask = null;
            this.interrupt = false;
        }
    }

    private synchronized boolean scheduleInterrupt(int timeout) {
        boolean wasInterrupt = this.interrupt;
        this.interrupt = false;
        if (this.interruptTimer == null) {
            this.interruptTimer = new Timer("Universe-Force-Close");
        } else if (this.interruptTask != null) {
            this.interruptTask.cancel();
        }
        this.interruptTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UniverseExecutionImpl universeExecutionImpl = UniverseExecutionImpl.this;
                synchronized (universeExecutionImpl) {
                    if (this == UniverseExecutionImpl.this.interruptTask) {
                        UniSession recentSession = UniverseExecutionImpl.this.uniSession;
                        UniverseExecutionImpl.this.interruptTask = null;
                        UniverseExecutionImpl.this.interrupt = true;
                        if (UniverseExecutionImpl.this.connectingThread != null) {
                            UniverseExecutionImpl.this.logFine("Interrupt no. [" + System.identityHashCode(this) + "]");
                            UniverseExecutionImpl.this.connectingThread.interrupt();
                        } else if (recentSession != null) {
                            try {
                                UniverseExecutionImpl.this.logFine("Forced close no. [" + System.identityHashCode(this) + "]");
                                Socket socket = ReflectionUtil.getFieldValue(recentSession, Socket.class, "connection", "socket", "socket");
                                try {
                                    socket.close();
                                }
                                catch (Exception e) {
                                    LogAPI.logSevere((Throwable)e);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        };
        this.logFine("Scheduling interrupt no. [" + System.identityHashCode(this.interruptTask) + "] in " + timeout + " ms");
        this.interruptTimer.schedule(this.interruptTask, timeout);
        return wasInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws UniSessionException, CancelException {
        UniverseExecutionImpl universeExecutionImpl = this;
        synchronized (universeExecutionImpl) {
            this.connectingThread = Thread.currentThread();
        }
        try {
            if (System.getProperty("clientencoding") == null) {
                throw new IllegalStateException("UV connection clientencoding undefined!");
            }
            universeExecutionImpl = uniJava;
            synchronized (universeExecutionImpl) {
                this.uniSession = uniJava.openSession();
            }
            this.fewTimes(new TryBlock(){

                @Override
                public void run() throws UniSessionException, CancelException {
                    UniverseExecutionImpl.this.checkCancel();
                    if (UniverseExecutionImpl.this.payrollServer.getPort() == null) {
                        UniverseExecutionImpl.this.uniSession.connect((Object)UniverseExecutionImpl.this.payrollServer.getHostOrLocalhost(), (Object)UniverseExecutionImpl.this.payrollServer.getUser(), (Object)UniverseExecutionImpl.this.payrollServer.getPassword(), (Object)UniverseExecutionImpl.this.payrollServer.getAccount());
                    } else {
                        UniverseExecutionImpl.this.uniSession.connect((Object)UniverseExecutionImpl.this.payrollServer.getHostOrLocalhost(), UniverseExecutionImpl.this.payrollServer.getPort().intValue(), (Object)UniverseExecutionImpl.this.payrollServer.getUser(), (Object)UniverseExecutionImpl.this.payrollServer.getPassword(), (Object)UniverseExecutionImpl.this.payrollServer.getAccount());
                    }
                }
            });
        }
        finally {
            universeExecutionImpl = this;
            synchronized (universeExecutionImpl) {
                Thread.interrupted();
                this.connectingThread = null;
            }
        }
    }

    private String payrollName() {
        return this.uniSession.getHostName() + "(" + this.uniSession.getAccountPath() + ")";
    }

    private void obtainTaskLock(final int lockNumber) throws PluginException, CancelException {
        try {
            this.fewTimes(new TryBlock(){

                @Override
                public void run() throws UniSessionException, CancelException {
                    UniverseExecutionImpl.this.checkCancel();
                    UniverseExecutionImpl.this.uniSession.setTaskLock(lockNumber);
                }
            });
        }
        catch (UniSessionException e) {
            this.handleUniSessionError(e);
            throw new TaskLockException(this.payrollName(), (Throwable)e, this.payrollServer, lockNumber);
        }
    }

    private void releaseTaskLock(final int lockNumber) throws UniSessionException, CancelException {
        this.fewTimes(new TryBlock(){

            @Override
            public void run() throws UniSessionException {
                UniverseExecutionImpl.this.uniSession.releaseTaskLock(lockNumber);
            }
        });
    }

    private void fewTimes(TryBlock block) throws CancelException, UniSessionException {
        int attempt = NUMBER_OF_RETRY_ATTEMPTS;
        while (true) {
            try {
                block.run();
                return;
            }
            catch (UniSessionException e) {
                block7: {
                    this.checkInterrupt(e);
                    if (this.isRecoverable(e) && attempt > 1) {
                        try {
                            LogAPI.logWarning((Throwable)e);
                            if (!this.cancel) {
                                Thread.sleep(2000L);
                            }
                            break block7;
                        }
                        catch (InterruptedException interrupted) {
                            this.checkInterrupt(interrupted);
                        }
                    }
                    throw e;
                }
                --attempt;
                continue;
            }
            break;
        }
    }

    boolean isRecoverable(UniSessionException e) {
        switch (e.getErrorCode()) {
            case 14005: 
            case 14028: 
            case 14551: 
            case 30002: 
            case 39131: 
            case 39134: 
            case 39202: 
            case 39207: 
            case 45001: 
            case 81001: 
            case 81002: 
            case 81007: 
            case 81009: 
            case 81011: 
            case 81015: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.uniSession != null && this.uniSession.isActive()) {
            try {
                this.uniSession.disconnect();
            }
            catch (UniSessionException e) {
                this.logSevere(e);
            }
        }
        try {
            UniJava uniJava = UniverseExecutionImpl.uniJava;
            synchronized (uniJava) {
                try {
                    Field field = UniJava.class.getDeclaredField("uniSessionsVector");
                    field.setAccessible(true);
                    Vector uniSessionsVector = (Vector)field.get(null);
                    uniSessionsVector.remove(this.uniSession);
                }
                catch (Exception e) {
                    LogAPI.logSevere((Throwable)e);
                }
            }
        }
        finally {
            this.uniSession = null;
        }
    }

    protected class UniverseSessionImpl
    implements UniverseSession {
        protected UniverseSessionImpl() {
        }

        public void checkInterrupt(Throwable cause) throws CancelException {
            UniverseExecutionImpl.this.checkInterrupt(cause);
        }

        public void checkCancel() throws CancelException {
            UniverseExecutionImpl.this.checkCancel();
        }

        @Override
        public UniverseFile universeFile(String fileName) throws PluginException, CancelException {
            return new UniverseFileImpl(this, UniverseExecutionImpl.this.uniSession, fileName);
        }

        @Override
        public List<String> executeQuery(String fileName) throws PluginException, CancelException {
            try {
                this.executeCommand("select " + fileName);
                UniverseExecutionImpl.this.logFiner("selectList(0)");
                UniSelectList selectList = UniverseExecutionImpl.this.uniSession.selectList(0);
                this.checkCancel();
                UniverseExecutionImpl.this.logFiner("readList(0)");
                UniDynArray ids = selectList.readList();
                ArrayList<String> result = new ArrayList<String>(ids.dcount());
                for (int i = 1; i <= ids.dcount(); ++i) {
                    result.add(ids.extract(i).toString());
                }
                return result;
            }
            catch (UniSessionException e) {
                switch (e.getErrorCode()) {
                    case 39120: {
                        this.checkInterrupt(e);
                    }
                }
                throw new IllegalStateException(e);
            }
            catch (UniSelectListException e) {
                switch (e.getErrorCode()) {
                    case 30114: {
                        throw new IllegalStateException(e);
                    }
                }
                this.checkInterrupt(e);
                if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                    throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
                }
                throw new PluginException(e);
            }
            catch (RuntimeException e) {
                this.checkInterrupt(e);
                throw e;
            }
        }

        @Override
        public void executeCommand(String string) throws UniverseRPCException, PluginException, CancelException {
            this.checkCancel();
            try {
                UniverseExecutionImpl.this.logFiner(string);
                UniCommand command = UniverseExecutionImpl.this.uniSession.command((Object)string);
                command.exec();
                do {
                    UniverseExecutionImpl.this.logFiner(command.response());
                } while (command.status() == 2);
            }
            catch (UniCommandException e) {
                switch (e.getErrorCode()) {
                    case 14022: 
                    case 30114: {
                        throw new IllegalStateException(e);
                    }
                }
                this.checkInterrupt(e);
                if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                    throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
                }
                throw new PluginException(e);
            }
            catch (UniSessionException e) {
                switch (e.getErrorCode()) {
                    case 39120: {
                        this.checkInterrupt(e);
                    }
                }
                throw new IllegalStateException(e);
            }
            catch (RuntimeException e) {
                this.checkInterrupt(e);
                throw e;
            }
        }

        @Override
        public void executeSubroutine(String name) throws PluginException, CancelException {
            this.executeSubroutine(name, new StringHolder[0]);
        }

        @Override
        public void executeSubroutine(String name, String ... args) throws PluginException, CancelException {
            StringHolder[] stringHolders = new StringHolder[args.length];
            for (int i = 0; i < args.length; ++i) {
                stringHolders[i] = new StringHolder(args[i]);
            }
            this.executeSubroutine(name, stringHolders);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeSubroutine(String name, StringHolder ... args) throws PluginException, CancelException {
            this.checkCancel();
            try {
                UniverseExecutionImpl.this.logFiner(name + Arrays.toString(args));
                UniSubroutine subroutine = UniverseExecutionImpl.this.uniSession.subroutine((Object)name, args.length + 1);
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].string == null) continue;
                    subroutine.setArg(i, (Object)args[i].string);
                }
                int originalTimetout = UniverseExecutionImpl.this.uniSession.getTimeout();
                try {
                    UniverseExecutionImpl.this.uniSession.setTimeout(1800);
                    subroutine.call();
                }
                finally {
                    UniverseExecutionImpl.this.uniSession.setTimeout(originalTimetout);
                }
                String error = subroutine.getArg(args.length);
                if (error.length() > 0) {
                    throw new PayrollErrorException(UniverseExecutionImpl.this.uniSession, error.split(String.valueOf(UniTokens.FM_CHAR)));
                }
                for (int i = 0; i < args.length; ++i) {
                    args[i].string = "".equals(subroutine.getArg(i)) ? null : subroutine.getArg(i).replaceAll(String.valueOf(UniTokens.FM_CHAR), ". ");
                }
            }
            catch (UniSessionException e) {
                switch (e.getErrorCode()) {
                    case 39120: {
                        this.checkInterrupt(e);
                    }
                }
                throw new IllegalStateException(e);
            }
            catch (UniSubroutineException e) {
                switch (e.getErrorCode()) {
                    case 30114: {
                        throw new IllegalStateException(e);
                    }
                    case 30107: 
                    case 81009: {
                        this.checkInterrupt(e);
                        String[] strings = new String[args.length];
                        for (int i = 0; i < strings.length; ++i) {
                            strings[i] = args[i].string;
                        }
                        throw new SubroutineException(UniverseExecutionImpl.this.uniSession, name, strings, (Exception)((Object)e));
                    }
                }
                this.checkInterrupt(e);
                if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                    throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
                }
                throw new PluginException(e);
            }
            catch (RuntimeException e) {
                this.checkInterrupt(e);
                throw e;
            }
        }

        UniverseVersion serverVersion() throws PluginException, CancelException {
            UniverseVersion result;
            if (versions.containsKey(UniverseExecutionImpl.this.payrollServer.getHostOrLocalhost())) {
                result = (UniverseVersion)versions.get(UniverseExecutionImpl.this.payrollServer.getHostOrLocalhost());
            } else {
                try {
                    UniFile file = UniverseExecutionImpl.this.uniSession.openFile((Object)"VOC");
                    String version = file.readField((Object)"RELLEVEL", 2).toString();
                    result = new UniverseVersion(version);
                    versions.put(UniverseExecutionImpl.this.payrollServer.getHostOrLocalhost(), result);
                }
                catch (UniSessionException e) {
                    this.handleFileOpenFailure("VOC", e);
                    throw new IllegalStateException(e);
                }
                catch (UniFileException e) {
                    this.handleFileReadError(e);
                    throw new IllegalStateException(e);
                }
            }
            return result;
        }

        void handleFileReadError(UniFileException e) throws CancelException, UniverseRPCException, PluginException {
            switch (e.getErrorCode()) {
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException();
                }
            }
            this.checkInterrupt(e);
            if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }

        void handleFileOpenFailure(String fileName, UniSessionException e) throws UniverseFileNotFoundException, UniverseRPCException, PluginException, CancelException {
            switch (e.getErrorCode()) {
                case 39120: {
                    this.checkInterrupt(e);
                }
                case 14022: 
                case 30112: 
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException(e);
                }
                case 14002: {
                    throw new UniverseFileNotFoundException(fileName, e);
                }
            }
            this.checkInterrupt(e);
            if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }

        void handleFileCloseFailure(UniFileException e) throws PluginException, CancelException {
            switch (e.getErrorCode()) {
                case 30114: {
                    throw new IllegalStateException(e);
                }
            }
            this.checkInterrupt(e);
            if (UniverseExecutionImpl.this.uniSession.getRPCError()) {
                throw new UniverseRPCException(UniverseExecutionImpl.this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }
    }

    private static interface TryBlock {
        public void run() throws UniSessionException, CancelException;
    }
}

