/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.memory;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.core.IPayrollCheckedP6P6BMessage;
import com.selima.fbi.core.IPayrollCheckedP9Message;
import com.selima.fbi.loader.PAYEBeanMessageLoader;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.sender.ISenderDetails;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.fbi.util.StringUtil;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MemoryPayrollPlugin
implements IPayrollPlugin {
    volatile boolean cancel;
    volatile boolean cancelable;
    protected EventBroadcast<IPayrollPluginListener> listeners = EventBroadcastFactory.createEventBroadcast(IPayrollPluginListener.class);
    protected static List<String> exampleTaxCodes = Arrays.asList("474L", "474P", "475V", "382Y", "384T", "K384", "BR", "OT", "DO", "NT");
    protected int exampleTaxCodeIndex;
    Map<String, Map<String, IDPSMessage>> map = new HashMap<String, Map<String, IDPSMessage>>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Map<String, IDPSMessage> get(Object key) {
            HashMap result = (HashMap)super.get(key);
            if (result == null) {
                result = new HashMap();
                this.put((String)key, result);
            }
            return result;
        }
    };
    protected PAYEBeanMessageLoader loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPAYEMessage> retrievePAYEMessages(PayrollServerSpec payrollServer, FormType formType, int year, ISenderDetails senderDetails, String empRef) throws PluginException, CancelException {
        this.setCancelable(true);
        try {
            ArrayList<IPAYEMessage> result = new ArrayList<IPAYEMessage>(2);
            LinkedList<InputStream> streams = new LinkedList<InputStream>();
            for (String resource : Arrays.asList(year + "-" + (Object)((Object)formType) + ".xml", year + "-" + (Object)((Object)formType) + "-Problematic.xml", (Object)((Object)formType) + ".xml", (Object)((Object)formType) + "-Problematic.xml")) {
                this.addStreamForResource(streams, resource, empRef);
            }
            for (InputStream stream : streams) {
                this.buildMessagesFromStream(result, stream, empRef, year);
            }
            ArrayList<IPAYEMessage> arrayList = result;
            return arrayList;
        }
        finally {
            this.setCancelable(false);
            ((IPayrollPluginListener)this.listeners.getListener()).finishedRun();
        }
    }

    protected boolean addStreamForResource(List<InputStream> streams, String resource, String empRef) throws CancelException {
        this.checkCancel();
        InputStream stream = MemoryPayrollPlugin.class.getResourceAsStream(resource);
        if (stream != null) {
            streams.add(stream);
            ((IPayrollPluginListener)this.listeners.getListener()).registerFutureStep("Loading " + resource + " for " + empRef);
            return true;
        }
        return false;
    }

    protected void buildMessagesFromStream(List<IPAYEMessage> results, InputStream stream, String empRef, int taxYear) throws CancelException {
        this.checkCancel();
        this.delay(750);
        this.checkCancel();
        this.buildMessagesFromTemplate(results, stream, empRef, taxYear, new HashMap<String, String>(4));
        ((IPayrollPluginListener)this.listeners.getListener()).finishedStep("Loaded " + results.get(results.size() - 1).getSubject() + " for " + empRef);
    }

    protected List<IPAYEMessage> buildMessagesFromTemplate(List<IPAYEMessage> results, InputStream stream, String empRef, int taxYear, Map<String, String> replacements) {
        CharSequence template = StringUtil.loadTemplate(stream);
        if (template != null) {
            if (this.loader == null) {
                ((IPayrollPluginListener)this.listeners.getListener()).registerCurrentStep("Building Message Loader ");
                this.loader = new PAYEBeanMessageLoader();
                ((IPayrollPluginListener)this.listeners.getListener()).finishedStep("Message Loader ready");
            }
            String[] parts = empRef.split("/");
            replacements.put("%Number%", parts[0]);
            replacements.put("%Reference%", parts[1]);
            replacements.put("%TaxYear%", String.valueOf(taxYear));
            replacements.put("%StartYear%", String.valueOf(taxYear - 1));
            replacements.put("%EndYear%", String.valueOf(taxYear));
            replacements.put("%StartYear-EndYear%", String.format("%d-%d", (taxYear - 1) % 100, taxYear % 100));
            if (!replacements.containsKey("%UniqueID%")) {
                replacements.put("%UniqueID%", taxYear + "-" + (results.size() + 1));
            }
            CharSequence xmldata = StringUtil.replace(template, replacements);
            try {
                results.add((IPAYEMessage)this.loader.load("UTF-8", xmldata.toString()));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDPSMessage(PayrollServerSpec payrollServer, IDPSMessage message, boolean firstInRow) throws PluginException, CancelException {
        try {
            ((IPayrollPluginListener)this.listeners.getListener()).registerFutureStep("Transferring " + message.getSubject());
            this.delay(1000);
            this.checkCancel();
            this.map.get(message.getEmpRef()).put(message.getStoreId(), message);
            ((IPayrollPluginListener)this.listeners.getListener()).finishedStep("Transferred " + message.getSubject());
        }
        finally {
            ((IPayrollPluginListener)this.listeners.getListener()).finishedRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDPSMessage(PayrollServerSpec payroll, IPayrollCheckedMessage message, boolean firstInBatch) throws PluginException, CancelException {
        try {
            ((IPayrollPluginListener)this.listeners.getListener()).registerFutureStep("Checking " + message.getSubject());
            this.delay(50);
            this.checkCancel();
            if (message instanceof IPayrollCheckedP6P6BMessage) {
                IPayrollCheckedP6P6BMessage p6 = (IPayrollCheckedP6P6BMessage)message;
                if (this.map.get(message.getEmpRef()).containsKey(message.getStoreId())) {
                    p6.setPayrollTaxCode(p6.getTaxCode());
                    p6.setPayrollWeek1Month1Indicator(p6.getWeek1Month1Indicator());
                    p6.setPayrollTotalPreviousPay(p6.getPayrollTotalPrevousPay());
                    p6.setPayrollTotalPreviousTax(p6.getPayrollTotalPrevousTax());
                    p6.setPayrollWarningMessage(null);
                } else {
                    p6.setPayrollTaxCode(exampleTaxCodes.get(this.exampleTaxCodeIndex++ % exampleTaxCodes.size()));
                    p6.setPayrollWeek1Month1Indicator(false);
                    p6.setPayrollTotalPreviousPay(p6.getPayrollTotalPrevousPay() != null ? new BigDecimal(p6.getPayrollTotalPrevousPay().toString()).add(new BigDecimal(1000)) : Integer.valueOf(42));
                    p6.setPayrollTotalPreviousTax(p6.getPayrollTotalPrevousTax() != null ? new BigDecimal(p6.getPayrollTotalPrevousTax().toString()).add(new BigDecimal(1000)) : Integer.valueOf(42));
                    p6.setPayrollTaxRegime("T");
                    message.setPayrollWarningMessage(this.exampleTaxCodeIndex % 3 == 0 ? "Some Payroll Warning" : null);
                }
            }
            if (message instanceof IPayrollCheckedP9Message) {
                IPayrollCheckedP9Message p9 = (IPayrollCheckedP9Message)message;
                if (this.map.get(message.getEmpRef()).containsKey(message.getStoreId())) {
                    p9.setPayrollTaxCode(p9.getTaxCode());
                    p9.setPayrollWeek1Month1Indicator(p9.isPayrollWeek1Month1Indicator());
                    p9.setPayrollWarningMessage(null);
                } else {
                    p9.setPayrollTaxCode(exampleTaxCodes.get(this.exampleTaxCodeIndex++ % exampleTaxCodes.size()));
                    p9.setPayrollWeek1Month1Indicator(false);
                    p9.setPayrollTaxRegime("T");
                    p9.setPayrollWarningMessage(this.exampleTaxCodeIndex % 3 == 0 ? "Some Payroll Warning" : null);
                }
            }
            ((IPayrollPluginListener)this.listeners.getListener()).finishedStep("Check" + message.getSubject());
        }
        finally {
            ((IPayrollPluginListener)this.listeners.getListener()).finishedRun();
        }
    }

    @Override
    public boolean isTransferrable(FormType formType) {
        return Arrays.asList(FormType.P6, FormType.P6B, FormType.P9, FormType.SL1, FormType.SL2, FormType.NOT, FormType.NVR).contains((Object)formType);
    }

    @Override
    public boolean isRetrievable(FormType formType) {
        return formType.isOutgoing() && formType != FormType.UKNOWN;
    }

    @Override
    public void testConnection(PayrollServerSpec payroll) throws PluginException, CancelException {
        ((IPayrollPluginListener)this.listeners.getListener()).registerFutureStep("Connecting Payroll");
        this.setCancelable(true);
        try {
            this.checkCancel();
            this.delay(1500);
            this.checkCancel();
            ((IPayrollPluginListener)this.listeners.getListener()).finishedStep("Payroll connected");
        }
        finally {
            this.setCancelable(false);
            ((IPayrollPluginListener)this.listeners.getListener()).finishedRun();
        }
    }

    private void delay(int length) {
        try {
            Thread.sleep(length);
        }
        catch (InterruptedException e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    protected synchronized void setCancelable(boolean state) {
        this.cancelable = state;
        this.cancel = false;
    }

    protected synchronized void checkCancel() throws CancelException {
        if (this.cancel) {
            throw new CancelException();
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancel = this.cancelable;
        if (this.cancel) {
            ((IPayrollPluginListener)this.listeners.getListener()).canceled();
        }
    }

    @Override
    public void addPluginListener(IPayrollPluginListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void removePluginListener(IPayrollPluginListener listener) {
        this.listeners.removeListener((Object)listener);
    }
}

