/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2019.impl.FPSEmployeeEntry2019AndBeyond;
import com.selima.fbi.core.payebeans.rti2019.impl.FPSLettersAndValues2019AndBeyond;
import com.selima.fbi.core.payebeans.rti2020.impl.FPSEmploymentEntry2020AndBeyond;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.builder.entry.AbstractFPSEntryBuilder2019AndBeyond;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.List;

abstract class FPSEntryBuilder2020AndBeyond<EmployeeEntry extends FPSEmployeeEntry2019AndBeyond, LettersAndValues extends FPSLettersAndValues2019AndBeyond, EmploymentEntry extends FPSEmploymentEntry2020AndBeyond>
extends AbstractFPSEntryBuilder2019AndBeyond<EmployeeEntry, LettersAndValues, EmploymentEntry> {
    List<String> postgradLoans;
    List<Number> postgradLoansTD;
    List<Number> postgradLoanRecovered;

    FPSEntryBuilder2020AndBeyond() {
    }

    @Override
    protected List<EmploymentEntry> readEmployements(List<LettersAndValues> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        this.postgradLoans = record.readMultivaluedStrings("POSTGRAD_LOAN");
        this.postgradLoansTD = record.readMultivaluedNumbers("POSTGRAD_LOAN_YTD");
        this.postgradLoanRecovered = record.readMultivaluedNumbers("POSTGRAD_LOAN_TP");
        return super.readEmployements(niLettersAndValues, record);
    }

    @Override
    protected EmploymentEntry newFPSEmployment(int index, List<LettersAndValues> niLettersAndValues) {
        FPSEmploymentEntry2020AndBeyond result = (FPSEmploymentEntry2020AndBeyond)super.newFPSEmployment(index, (List)niLettersAndValues);
        result.initPostgradLoan(YesType.fromUniverse(this.get(this.postgradLoans, index)));
        result.initPostgradLoansTD(this.get(this.postgradLoansTD, index));
        result.initPostgradLoanRecovered(this.get(this.postgradLoanRecovered, index));
        return (EmploymentEntry)result;
    }
}

