/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.BeanAddress;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2014.impl.EASEmployeeEntry2014;
import com.selima.fbi.core.payebeans.rti2014.impl.EASEmploymentEntry2014;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.PayrollDataFormatException;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class EASEntryBuilder
implements UniverseEntryBuilder<EASEmployeeEntry2014> {
    String officeNo;
    String payeRef;
    String aoRef;

    public String getOfficeNo() {
        return this.officeNo;
    }

    public String getPayeRef() {
        return this.payeRef;
    }

    public String getAoRef() {
        return this.aoRef;
    }

    @Override
    public EASEmployeeEntry2014 build(UniverseRecord record) throws PluginException, CancelException {
        this.readMessageLevelValues(record);
        List<EASEmploymentEntry2014> employments = this.readEmployments(record);
        EASEmployeeEntry2014 employeeEntry = this.readEmployee(employments, record);
        return employeeEntry;
    }

    private void readMessageLevelValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        if (this.officeNo == null) {
            this.officeNo = record.readString("HMRC_OFFICE_NUMBER");
        }
        if (this.payeRef == null) {
            this.payeRef = record.readString("EMPLOYER_PAYE_REF");
        }
        if (this.aoRef == null) {
            this.aoRef = record.readString("EMPLOYER_ACCOUNTS_OFFICE");
        }
    }

    private EASEmployeeEntry2014 readEmployee(List<EASEmploymentEntry2014> employments, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException, PayrollDataFormatException {
        EASEmployeeEntry2014 easEntry = new EASEmployeeEntry2014(employments);
        easEntry.initTitle(record.readString("TITLE"));
        easEntry.initFore1(this.trim(record.readString("FORENAME")));
        easEntry.initFore2(this.trim(record.readString("SECOND_FORENAME")));
        easEntry.initSurname(record.readString("SURNAME"));
        easEntry.initNino(record.readString("NINO"));
        easEntry.initBirthDate(record.readDate("DOB"));
        easEntry.initGender(record.readString("GENDER"));
        BeanAddress employeeAddress = new BeanAddress(record.readStrings("EMPLOYEE_ADDRESS_LINE1", "EMPLOYEE_ADDRESS_LINE2", "EMPLOYEE_ADDRESS_LINE3", "EMPLOYEE_ADDRESS_LINE4"), record.readString("EMPLOYEE_POSTCODE"), record.readString("FOREIGN_COUNTRY"));
        easEntry.initAddress(employeeAddress);
        return easEntry;
    }

    private List<EASEmploymentEntry2014> readEmployments(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException, PayrollDataFormatException {
        List<String> taxCodes = record.readMultivaluedStrings("TAX_CODE");
        List<String> taxBasis = record.readMultivaluedStrings("TAX_BASIS");
        List<String> irregularPayments = record.readMultivaluedStrings("IRREGULAR_PAYMENT");
        List<String> payrollIds = record.readMultivaluedStrings("PAYROLL_ID");
        List<Date> startDates = record.readMultivaluedDates("START_DATE");
        List<Date> leavingDates = record.readMultivaluedDates("LEAVING_DATE");
        List<String> expats = record.readMultivaluedStrings("EXPAT");
        ArrayList<EASEmploymentEntry2014> result = new ArrayList<EASEmploymentEntry2014>(taxCodes.size());
        int i = 0;
        for (String taxCode : taxCodes) {
            if (taxCode == null) continue;
            EASEmploymentEntry2014 employment = new EASEmploymentEntry2014();
            employment.initIrrEmp(YesType.fromUniverse(this.get(irregularPayments, i)));
            employment.initPayId(this.get(payrollIds, i));
            employment.initStartDate(this.get(startDates, i));
            employment.initLeavingDate(this.get(leavingDates, i));
            employment.initTaxCodes(Collections.singletonList(taxCode));
            employment.initTaxBasis(Collections.singletonList(YesType.fromUniverse(this.get(taxBasis, i))));
            employment.initExpatInd(YesType.fromUniverse(this.get(expats, i)));
            result.add(employment);
            ++i;
        }
        return result;
    }

    protected <T> T get(List<T> list, int i) {
        return list.size() > i ? (T)list.get(i) : null;
    }

    protected String trim(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }
}

