/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2016.impl.FPSEmploymentEntry2016Beyond;
import com.selima.fbi.core.payebeans.rti2017.impl.FPSEmployeeEntry2017AndBeyond;
import com.selima.fbi.core.payebeans.rti2017.impl.FPSEmploymentEntry2017AndBeyond;
import com.selima.fbi.core.payebeans.rti2017.impl.FPSLettersAndValues2017AndBeyond;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.builder.entry.AbstractFPSEmployeeEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.List;

abstract class AbstractFPSEntryBuilder2017AndBeyond<FPSEmployeeEntry extends FPSEmployeeEntry2017AndBeyond, FPSLettersAndValues extends FPSLettersAndValues2017AndBeyond, FPSEmploymentEntry extends FPSEmploymentEntry2017AndBeyond>
extends AbstractFPSEmployeeEntryBuilder<FPSEmployeeEntry, FPSLettersAndValues, FPSEmploymentEntry> {
    private List<String> lateReason;
    private List<Number> sppYTD;
    private List<Number> shppYTD;
    private List<String> taxRegime;
    private List<String> flexiblyAccessingPendionRights;
    private List<String> pensionDeathBenefit;
    private List<Number> taxablePayment;
    private List<Number> nonTaxablePayment;
    private List<Number> ptToUELYTD;

    AbstractFPSEntryBuilder2017AndBeyond() {
    }

    @Override
    protected List<FPSLettersAndValues> readNILettersAndValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        this.ptToUELYTD = record.readMultivaluedNumbers("TO_UAP_CF");
        return super.readNILettersAndValues(record);
    }

    @Override
    protected FPSLettersAndValues newNILettersAndValues(int index) {
        FPSLettersAndValues lettersAndValues = this.newFPSLettersAndValues2017AndBeyond();
        ((FPSLettersAndValues2017AndBeyond)lettersAndValues).initPtToUELYTD(this.get(this.ptToUELYTD, index));
        return lettersAndValues;
    }

    @Override
    protected List<FPSEmploymentEntry> readEmployements(List<FPSLettersAndValues> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        this.lateReason = record.readMultivaluedStrings("LATE_REPORTING_REASON");
        this.sppYTD = record.readMultivaluedNumbers("OSPP_YTD");
        this.shppYTD = record.readMultivaluedNumbers("ASPP_YTD");
        this.taxRegime = record.readMultivaluedStrings("SVR_IND");
        this.flexiblyAccessingPendionRights = record.readMultivaluedStrings("FLEX_PEN");
        this.pensionDeathBenefit = record.readMultivaluedStrings("DEATH_BEN");
        this.taxablePayment = record.readMultivaluedNumbers("FLEX_PEN_TAX");
        this.nonTaxablePayment = record.readMultivaluedNumbers("FLEX_PEN_NTAX");
        return super.readEmployements(niLettersAndValues, record);
    }

    @Override
    protected FPSEmploymentEntry newFPSEmployment(int index, List<FPSLettersAndValues> niLettersAndValues) {
        FPSEmploymentEntry result = this.newFPSEmploymentEntry2017AndBeyond(niLettersAndValues);
        ((FPSEmploymentEntry2016Beyond)result).initLateReason(this.get(this.lateReason, index));
        ((FPSEmploymentEntry2016Beyond)result).initSppYTD(this.get(this.sppYTD, index));
        ((FPSEmploymentEntry2016Beyond)result).initShppYTD(this.get(this.shppYTD, index));
        ((FPSEmploymentEntry2017AndBeyond)result).initTaxRegime(this.get(this.taxRegime, index));
        ((FPSEmploymentEntry2016Beyond)result).initFlexiblyAccessingPensionRights(YesType.fromUniverse(this.get(this.flexiblyAccessingPendionRights, index)));
        ((FPSEmploymentEntry2017AndBeyond)result).initPensionDeathBenefit(YesType.fromUniverse(this.get(this.pensionDeathBenefit, index)));
        ((FPSEmploymentEntry2017AndBeyond)result).initTaxablePayment(this.get(this.taxablePayment, index));
        ((FPSEmploymentEntry2017AndBeyond)result).initNonTaxablePayment(this.get(this.nonTaxablePayment, index));
        return result;
    }

    protected abstract FPSEmploymentEntry newFPSEmploymentEntry2017AndBeyond(List<FPSLettersAndValues> var1);

    protected abstract FPSLettersAndValues newFPSLettersAndValues2017AndBeyond();
}

