/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.impl.AbstractBeanMessage;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.FBIFileName;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseFile;
import com.selima.fbi.plugin.u2.UniverseRecord;
import com.selima.fbi.plugin.u2.UniverseSession;
import com.selima.fbi.sender.ISenderDetails;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractMessageBuilder<EntryType, EntryBuilderType extends UniverseEntryBuilder<EntryType>> {
    IPayrollPluginListener listener;
    final EntryBuilderType entryBuilder;
    final ISenderDetails senderDetails;
    final int taxYear;
    final FBIFileName fileName;
    final String empRef;

    AbstractMessageBuilder(String filePrefix, String empRef, int taxYear, EntryBuilderType entryBuilder, ISenderDetails senderDetails) {
        this.fileName = new FBIFileName(filePrefix, empRef, taxYear);
        this.senderDetails = senderDetails;
        this.entryBuilder = entryBuilder;
        this.taxYear = taxYear;
        this.empRef = empRef;
    }

    public void registerFuture(IPayrollPluginListener listener) {
        this.listener = listener;
        listener.registerFutureStep("Invoking RefreshFileForFBI" + Arrays.toString(this.fileName.toRefreshArguments()));
        listener.registerFutureStep("Getting file " + this.fileName);
        listener.registerFutureStep("Getting ids from " + this.fileName);
        listener.registerFutureStep("Reading records from " + this.fileName);
        listener.registerFutureStep("Building message");
    }

    protected void finished(String text) {
        this.listener.finishedStep(text);
    }

    protected void startingStep(int count) {
        this.listener.startingStep(count);
    }

    protected void reachedSubstep(String text) {
        this.listener.reachedSubstep(text);
    }

    public void run(UniverseSession universeSession, List<? super AbstractBeanMessage> messages) throws PluginException, CancelException {
        universeSession.executeSubroutine("RefreshFileForFBI", this.fileName.toRefreshArguments());
        this.finished("RefreshFileForFBI" + Arrays.toString(this.fileName.toRefreshArguments()) + " accomplished successfully");
        UniverseFile universeFile = universeSession.universeFile(this.fileName.toString());
        this.finished("Got " + this.fileName);
        List<String> ids = universeFile.readIds();
        this.finished(this.fileName + " contains " + ids.size() + " records");
        final int idsPerStep = Math.max(1, ids.size() / 100);
        this.startingStep(ids.size() / idsPerStep);
        List entries = universeFile.readRecords(ids, new UniverseEntryBuilder<EntryType>(){
            int counter;

            @Override
            public EntryType build(UniverseRecord rawRecord) throws PluginException, CancelException {
                Object result = AbstractMessageBuilder.this.entryBuilder.build(rawRecord);
                if (++this.counter % idsPerStep == 0) {
                    AbstractMessageBuilder.this.reachedSubstep("Read " + this.counter + " record" + (this.counter > 1 ? "s" : ""));
                }
                return result;
            }
        });
        this.finished(this.fileName + " read successfully");
        messages.add(this.newMessage(entries));
        this.finished("Message built successfully");
    }

    abstract AbstractBeanMessage newMessage(List<EntryType> var1);
}

