/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js;

import asjava.uniclientlibs.UniException;
import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.IPGL1Message;
import com.selima.fbi.core.IPGL2Message;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.core.IPayrollCheckedP6P6BMessage;
import com.selima.fbi.core.IPayrollCheckedP9Message;
import com.selima.fbi.core.IRTINotMessage;
import com.selima.fbi.core.ISL1Message;
import com.selima.fbi.core.ISL2Message;
import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.core.wrapper.PAYETechnicalWrapper;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.plugin.InsufficientSenderDetailsException;
import com.selima.fbi.plugin.PayrollPluginAdapter;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.UndefinedServerException;
import com.selima.fbi.plugin.js.builder.AbstractMessageBuilder;
import com.selima.fbi.plugin.js.builder.EASMessageBuilder;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2014;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2015;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2016;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2017;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2018;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2019;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2020;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2021;
import com.selima.fbi.plugin.js.builder.EPSMessageBuilder2022;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2013;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2014;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2015;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2016;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2017;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2018;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2019;
import com.selima.fbi.plugin.js.builder.EYUMessageBuilder2020;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2014;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2015;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2016;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2017;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2018;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2019;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2020;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2021;
import com.selima.fbi.plugin.js.builder.FPSMessageBuilder2022;
import com.selima.fbi.plugin.js.builder.NINOVRMessageBuilder;
import com.selima.fbi.plugin.u2.PayrollErrorException;
import com.selima.fbi.plugin.u2.StringHolder;
import com.selima.fbi.plugin.u2.UniverseExecution;
import com.selima.fbi.plugin.u2.UniverseExecutionCache;
import com.selima.fbi.plugin.u2.UniverseExecutionCacheImpl;
import com.selima.fbi.plugin.u2.UniverseSession;
import com.selima.fbi.plugin.u2.UniverseWork;
import com.selima.fbi.sender.ISenderDetails;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class JohnScholeyPayrollPlugin
extends PayrollPluginAdapter {
    static UniverseExecutionCache universeFactory = new UniverseExecutionCacheImpl();
    private volatile UniverseExecution universeExecution;
    private EventBroadcast<IPayrollPluginListener> listeners = EventBroadcastFactory.createEventBroadcast(IPayrollPluginListener.class);

    @Override
    public boolean isRetrievable(FormType formType) {
        return Arrays.asList(FormType.EPS, FormType.EYU, FormType.FPS, FormType.NINOVR).contains((Object)formType);
    }

    @Override
    public List<IPAYEMessage> retrievePAYEMessages(PayrollServerSpec payrollServer, FormType formType, int taxYear, ISenderDetails senderDetails, String empRef) throws PluginException, CancelException {
        if (senderDetails == null) {
            throw new InsufficientSenderDetailsException(empRef);
        }
        if (!senderDetails.isValid()) {
            throw new InsufficientSenderDetailsException(empRef, senderDetails.getValidationErrors());
        }
        if (!payrollServer.isSufficient()) {
            throw new UndefinedServerException(empRef);
        }
        final LinkedList rawMessages = new LinkedList();
        AbstractMessageBuilder messageBuilder = null;
        switch (formType) {
            case NINOVR: {
                switch (taxYear) {
                    case 2012: 
                    case 2013: 
                    case 2014: 
                    case 2015: 
                    case 2016: 
                    case 2017: 
                    case 2018: 
                    case 2019: 
                    case 2020: 
                    case 2021: 
                    case 2022: {
                        messageBuilder = new NINOVRMessageBuilder(empRef, taxYear, senderDetails);
                    }
                }
                break;
            }
            case EAS: {
                switch (taxYear) {
                    case 2012: 
                    case 2013: 
                    case 2014: 
                    case 2015: 
                    case 2016: 
                    case 2017: 
                    case 2018: {
                        messageBuilder = new EASMessageBuilder(empRef, taxYear, senderDetails);
                    }
                }
                break;
            }
            case EPS: {
                switch (taxYear) {
                    case 2022: {
                        messageBuilder = new EPSMessageBuilder2022(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2021: {
                        messageBuilder = new EPSMessageBuilder2021(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2020: {
                        messageBuilder = new EPSMessageBuilder2020(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2019: {
                        messageBuilder = new EPSMessageBuilder2019(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2018: {
                        messageBuilder = new EPSMessageBuilder2018(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2017: {
                        messageBuilder = new EPSMessageBuilder2017(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2016: {
                        messageBuilder = new EPSMessageBuilder2016(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2015: {
                        messageBuilder = new EPSMessageBuilder2015(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2014: {
                        messageBuilder = new EPSMessageBuilder2014(empRef, taxYear, senderDetails);
                    }
                }
                break;
            }
            case EYU: {
                switch (taxYear) {
                    case 2020: {
                        messageBuilder = new EYUMessageBuilder2020(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2019: {
                        messageBuilder = new EYUMessageBuilder2019(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2018: {
                        messageBuilder = new EYUMessageBuilder2018(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2017: {
                        messageBuilder = new EYUMessageBuilder2017(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2016: {
                        messageBuilder = new EYUMessageBuilder2016(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2015: {
                        messageBuilder = new EYUMessageBuilder2015(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2014: {
                        messageBuilder = new EYUMessageBuilder2014(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2013: {
                        messageBuilder = new EYUMessageBuilder2013(empRef, taxYear, senderDetails);
                    }
                }
                break;
            }
            case FPS: {
                switch (taxYear) {
                    case 2022: {
                        messageBuilder = new FPSMessageBuilder2022(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2021: {
                        messageBuilder = new FPSMessageBuilder2021(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2020: {
                        messageBuilder = new FPSMessageBuilder2020(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2019: {
                        messageBuilder = new FPSMessageBuilder2019(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2018: {
                        messageBuilder = new FPSMessageBuilder2018(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2017: {
                        messageBuilder = new FPSMessageBuilder2017(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2016: {
                        messageBuilder = new FPSMessageBuilder2016(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2015: {
                        messageBuilder = new FPSMessageBuilder2015(empRef, taxYear, senderDetails);
                        break;
                    }
                    case 2014: {
                        messageBuilder = new FPSMessageBuilder2014(empRef, taxYear, senderDetails);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)formType));
            }
        }
        if (messageBuilder != null) {
            this.registerFuture("Connecting Payroll");
            messageBuilder.registerFuture((IPayrollPluginListener)this.listeners.getListener());
            final AbstractMessageBuilder selectedBuilder = messageBuilder;
            this.execute(payrollServer, new UniverseWork<Void>(){

                @Override
                public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                    JohnScholeyPayrollPlugin.this.finished("Connected Payroll");
                    selectedBuilder.run(universeSession, rawMessages);
                    return null;
                }
            });
        }
        ArrayList<IPAYEMessage> result = new ArrayList<IPAYEMessage>(rawMessages.size());
        ListIterator it = rawMessages.listIterator();
        while (it.hasNext()) {
            result.add(this.wrap((IBeanMessage)it.next(), IBeanMessage.class));
        }
        return result;
    }

    private <T extends IBeanMessage> T wrap(T message, Class<T> type) {
        return (T)((IBeanMessage)new PAYETechnicalWrapper((IPAYEMessage)message.getProxy(type)).getProxy(type));
    }

    @Override
    public void checkDPSMessage(PayrollServerSpec payroll, final IPayrollCheckedMessage message, final boolean firstInBatch) throws PluginException, CancelException {
        if (payroll.isSufficient()) {
            this.registerFuture("Connecting Payroll", "Checking " + message.getSubject());
            this.execute(payroll, new UniverseWork<Void>(){

                @Override
                public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                    JohnScholeyPayrollPlugin.this.finished("Connected Payroll");
                    if (message instanceof IPayrollCheckedP6P6BMessage) {
                        IPayrollCheckedP6P6BMessage p6 = (IPayrollCheckedP6P6BMessage)message;
                        JohnScholeyPayrollPlugin.this.checkP6(universeSession, p6, firstInBatch);
                        JohnScholeyPayrollPlugin.this.finished("Checked " + message.getSubject());
                    }
                    if (message instanceof IPayrollCheckedP9Message) {
                        IPayrollCheckedP9Message p9 = (IPayrollCheckedP9Message)message;
                        JohnScholeyPayrollPlugin.this.checkP9(universeSession, p9, firstInBatch);
                        JohnScholeyPayrollPlugin.this.finished("Checked " + message.getSubject());
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void storeDPSMessage(PayrollServerSpec payroll, final IDPSMessage message, final boolean firstInRow) throws PluginException, CancelException {
        if (!payroll.isSufficient()) {
            throw new UndefinedServerException(message.getEmpRef());
        }
        this.registerFuture("Connecting Payroll", "Transferring " + message.getSubject());
        this.execute(payroll, new UniverseWork<Void>(){

            @Override
            public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                JohnScholeyPayrollPlugin.this.finished("Connected Payroll");
                if (message instanceof IP6P6BMessage) {
                    IP6P6BMessage p6 = (IP6P6BMessage)message;
                    JohnScholeyPayrollPlugin.this.acceptP6(universeSession, p6, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof IP9Message) {
                    IP9Message p9 = (IP9Message)message;
                    JohnScholeyPayrollPlugin.this.acceptP9(universeSession, p9, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof ISL1Message) {
                    ISL1Message sl1 = (ISL1Message)message;
                    JohnScholeyPayrollPlugin.this.acceptSL1(universeSession, sl1, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof IPGL1Message) {
                    IPGL1Message pgl1 = (IPGL1Message)message;
                    JohnScholeyPayrollPlugin.this.acceptPGL1(universeSession, pgl1, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof ISL2Message) {
                    ISL2Message sl2 = (ISL2Message)message;
                    JohnScholeyPayrollPlugin.this.acceptSL2(universeSession, sl2, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof IPGL2Message) {
                    IPGL2Message pgl2 = (IPGL2Message)message;
                    JohnScholeyPayrollPlugin.this.acceptPGL2(universeSession, pgl2, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                if (message instanceof IRTINotMessage) {
                    IRTINotMessage nvrOrNot = (IRTINotMessage)message;
                    JohnScholeyPayrollPlugin.this.acceptNOTorNVR(universeSession, nvrOrNot, firstInRow);
                    JohnScholeyPayrollPlugin.this.finished("Transferred " + message.getSubject());
                }
                return null;
            }
        });
    }

    protected void checkP9(UniverseSession universeSession, IPayrollCheckedP9Message p9, boolean firstInBatch) throws PluginException, CancelException {
        try {
            StringHolder payrollWarning;
            StringHolder payrollWeek1Month1Indicator;
            StringHolder payrollTaxRegime;
            StringHolder payrollTaxCode;
            universeSession.executeSubroutine("CheckP9", new StringHolder(p9.getEmpRef()), new StringHolder(p9.getNino()), new StringHolder(p9.getWorksNumber()), new StringHolder(this.format(p9.getEffectiveDate(), "dd/MM/yyyy")), new StringHolder(String.valueOf(p9.getTaxYearEnd())), new StringHolder(p9.getTaxCode()), new StringHolder(p9.getTaxRegime()), new StringHolder(p9.getWeek1Month1Indicator() ? "X" : ""), new StringHolder(firstInBatch ? "1" : "0"), payrollTaxCode = new StringHolder(), payrollTaxRegime = new StringHolder(), payrollWeek1Month1Indicator = new StringHolder(), payrollWarning = new StringHolder());
            p9.setPayrollTaxCode(payrollTaxCode.string);
            p9.setPayrollTaxRegime(payrollTaxRegime.string);
            p9.setPayrollWeek1Month1Indicator("X".equals(payrollWeek1Month1Indicator.string));
            p9.setPayrollWarningMessage(payrollWarning.string);
        }
        catch (PayrollErrorException e) {
            p9.setPayrollWarningMessage(e.getMessage());
        }
    }

    protected void checkP6(UniverseSession universeSession, IPayrollCheckedP6P6BMessage p6, boolean firstInBatch) throws PluginException, CancelException {
        try {
            StringHolder payrollWarning;
            StringHolder payrollTotalTax;
            StringHolder payrollTotalPay;
            StringHolder payrollWeek1MonthIndicator;
            StringHolder payrollTaxRegime;
            StringHolder payrollTaxCode;
            universeSession.executeSubroutine("CheckP6", new StringHolder(p6.getFormType().name()), new StringHolder(p6.getEmpRef()), new StringHolder(p6.getNino()), new StringHolder(p6.getWorksNumber()), new StringHolder(this.format(p6.getEffectiveDate(), "dd/MM/yyyy")), new StringHolder(String.valueOf(p6.getTaxYearEnd())), new StringHolder(p6.getTaxCode()), new StringHolder(p6.getTaxRegime()), new StringHolder(p6.getWeek1Month1Indicator() ? "X" : null), new StringHolder(p6.getTotalPreviousPay() != null ? this.format(p6.getTotalPreviousPay(), "0.00") : null), new StringHolder(p6.getTotalPreviousTax() != null ? this.format(p6.getTotalPreviousTax(), "0.00") : null), new StringHolder(firstInBatch ? "1" : "0"), payrollTaxCode = new StringHolder(), payrollTaxRegime = new StringHolder(), payrollWeek1MonthIndicator = new StringHolder(), payrollTotalPay = new StringHolder(), payrollTotalTax = new StringHolder(), payrollWarning = new StringHolder());
            p6.setPayrollTaxCode(payrollTaxCode.string);
            p6.setPayrollTaxRegime(payrollTaxRegime.string);
            p6.setPayrollWeek1Month1Indicator("X".equals(payrollWeek1MonthIndicator.string));
            if (payrollTotalPay.string != null) {
                p6.setPayrollTotalPreviousPay(new BigDecimal(payrollTotalPay.string));
            } else {
                p6.setPayrollTotalPreviousPay(null);
            }
            if (payrollTotalTax.string != null) {
                p6.setPayrollTotalPreviousTax(new BigDecimal(payrollTotalTax.string));
            } else {
                p6.setPayrollTotalPreviousTax(null);
            }
            p6.setPayrollWarningMessage(payrollWarning.string);
        }
        catch (PayrollErrorException e) {
            p6.setPayrollWarningMessage(e.getMessage());
        }
    }

    protected void acceptP6(UniverseSession universeSession, IP6P6BMessage p6, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptP6", p6.getFormType().name(), p6.getEmpRef(), p6.getNino(), p6.getWorksNumber(), this.format(p6.getEffectiveDate(), "dd/MM/yyyy"), String.valueOf(p6.getTaxYearEnd()), p6.getTaxCode(), p6.getTaxRegime(), p6.getWeek1Month1Indicator() ? "X" : null, p6.getTotalPreviousPay() != null ? this.format(p6.getTotalPreviousPay(), "0.00") : null, p6.getTotalPreviousTax() != null ? this.format(p6.getTotalPreviousTax(), "0.00") : null, firstInRow ? "1" : "0");
    }

    protected void acceptSL1(UniverseSession universeSession, ISL1Message sl1, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptSL1", sl1.getEmpRef(), sl1.getNino(), sl1.getWorksNumber(), sl1.getPlanType(), this.format(sl1.getStartDate(), "dd/MM/yyyy"), String.valueOf(sl1.getTaxYearEnd()), firstInRow ? "1" : "0");
    }

    protected void acceptPGL1(UniverseSession universeSession, IPGL1Message pgl1, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptPGL1", pgl1.getEmpRef(), pgl1.getNino(), pgl1.getWorksNumber(), null, this.format(pgl1.getStartDate(), "dd/MM/yyyy"), String.valueOf(pgl1.getTaxYearEnd()), firstInRow ? "1" : "0");
    }

    protected void acceptNOTorNVR(UniverseSession universeSession, IRTINotMessage message, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine(message.getFormType() == FormType.NOT ? "AcceptNOT" : "AcceptNVR", message.getEmpRef(), message.getNinoProvided(), message.getPayId(), message.getSurname(), message.getNinoToUse(), firstInRow ? "1" : "0");
    }

    protected void acceptSL2(UniverseSession universeSession, ISL2Message sl2, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptSL2", sl2.getEmpRef(), sl2.getNino(), sl2.getWorksNumber(), this.format(sl2.getStopDate(), "dd/MM/yyyy"), String.valueOf(sl2.getTaxYearEnd()), firstInRow ? "1" : "0");
    }

    protected void acceptPGL2(UniverseSession universeSession, IPGL2Message pgl2, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptPGL2", pgl2.getEmpRef(), pgl2.getNino(), pgl2.getWorksNumber(), this.format(pgl2.getStopDate(), "dd/MM/yyyy"), String.valueOf(pgl2.getTaxYearEnd()), firstInRow ? "1" : "0");
    }

    protected void acceptP9(UniverseSession universeSession, IP9Message p9, boolean firstInRow) throws PluginException, CancelException {
        universeSession.executeSubroutine("AcceptP9", p9.getEmpRef(), p9.getNino(), p9.getWorksNumber(), this.format(p9.getEffectiveDate(), "dd/MM/yyyy"), String.valueOf(p9.getTaxYearEnd()), p9.getTaxCode(), p9.getTaxRegime(), p9.getWeek1Month1Indicator() ? "1" : "0", firstInRow ? "1" : "0");
    }

    @Override
    public boolean isTransferrable(FormType formType) {
        return Arrays.asList(FormType.P6, FormType.P6B, FormType.P9, FormType.SL1, FormType.SL2, FormType.NOT, FormType.NVR, FormType.PGL1, FormType.PGL2).contains((Object)formType);
    }

    @Override
    public void testConnection(PayrollServerSpec payroll) throws PluginException, CancelException {
        payroll = payroll.clone();
        payroll.setTaskLock(63);
        this.registerFuture("Connecting Payroll", "Calling FBIcheck");
        this.execute(payroll, new UniverseWork<Void>(){

            @Override
            public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                JohnScholeyPayrollPlugin.this.finished("Connected Payroll");
                try {
                    universeSession.executeSubroutine("FBIcheck");
                    JohnScholeyPayrollPlugin.this.finished("FBIcheck finished successfully");
                }
                catch (PluginException e) {
                    UniException ue;
                    if (e.getCause() instanceof UniException && (ue = (UniException)e.getCause()).getErrorCode() == 30105) {
                        throw new PluginException("Payroll support for FBI is not properly installed in this payroll account. Failed to invoke <b>FBIcheck</b>. Subroutine not found.", (Throwable)ue);
                    }
                    throw e;
                }
                return null;
            }
        });
    }

    @Override
    public void cancel() {
        UniverseExecution currentExecution = this.universeExecution;
        if (currentExecution != null) {
            currentExecution.cancel();
            ((IPayrollPluginListener)this.listeners.getListener()).canceled();
        }
        super.cancel();
    }

    private void finished() {
        ((IPayrollPluginListener)this.listeners.getListener()).finishedRun();
    }

    protected void finished(String step) {
        ((IPayrollPluginListener)this.listeners.getListener()).finishedStep(step);
    }

    protected void registerFuture(String ... steps) {
        for (String step : steps) {
            ((IPayrollPluginListener)this.listeners.getListener()).registerFutureStep(step);
        }
    }

    @Override
    public void addPluginListener(IPayrollPluginListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void removePluginListener(IPayrollPluginListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    protected void execute(PayrollServerSpec payrollServer, UniverseWork<Void> pluginWork) throws PluginException, CancelException {
        this.universeExecution = universeFactory.connect(payrollServer);
        try {
            this.universeExecution.run(pluginWork);
        }
        finally {
            this.universeExecution = null;
            this.finished();
        }
    }

    protected String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    protected String format(Number date, String pattern) {
        return new DecimalFormat(pattern).format(date);
    }
}

