/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.HarmlessDPSPlugin;
import com.selima.fbi.user.PayrollServerSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class HarmlessP6Plugin
extends HarmlessDPSPlugin {
    public HarmlessP6Plugin(IPayrollPlugin plugin) {
        super(plugin);
    }

    @Override
    public void storeDPSMessage(PayrollServerSpec payrollServer, IDPSMessage message, boolean firstInRow) throws PluginException, CancelException {
        if (message.getFormType() == FormType.P6 || message.getFormType() == FormType.P6B) {
            message = (IDPSMessage)new HarmlessP6Message((IP6P6BMessage)message, this.nextHarmlessRecord()).getProxy();
        }
        super.storeDPSMessage(payrollServer, message, firstInRow);
    }

    static class HarmlessP6Message
    extends DPSMessageWrapper
    implements IP6P6BMessage {
        private HarmlessDPSPlugin.HarmlessRecord record;

        HarmlessP6Message(IP6P6BMessage message, HarmlessDPSPlugin.HarmlessRecord record) {
            super(message);
            this.record = record;
        }

        @Override
        public Date getEffectiveDate() {
            return new GregorianCalendar(this.getTaxYearEnd(), 3, 6).getTime();
        }

        @Override
        public String getNino() {
            return this.record.nino;
        }

        @Override
        public String getTaxCode() {
            return this.record.taxCode;
        }

        @Override
        public Number getTotalPreviousPay() {
            return this.record.totalPreviousPay;
        }

        @Override
        public Number getTotalPreviousTax() {
            return this.record.totalPreviousTax;
        }

        @Override
        public boolean getWeek1Month1Indicator() {
            return this.record.week1Month1Indicator;
        }

        @Override
        public int getTaxYearEnd() {
            return 2008;
        }

        @Override
        public String getWorksNumber() {
            return this.record.worksNumber;
        }

        private IP6P6BMessage wrappedP6() {
            return (IP6P6BMessage)this.wrapped;
        }

        @Override
        public String getSurname() {
            return this.wrappedP6().getSurname();
        }

        @Override
        public List<String> getForename() {
            return this.wrappedP6().getForename();
        }

        @Override
        public String getTaxRegime() {
            return this.wrappedP6().getTaxRegime();
        }
    }
}

