/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.wrapper.AbstractMessageWrapper;
import com.selima.fbi.core.wrapper.PAYETechnicalWrapper;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PayrollPluginWrapper;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.sender.ISenderDetails;
import com.selima.fbi.user.PayrollServerSpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class EmpRefMappingPlugin
extends PayrollPluginWrapper {
    String targetEmpRef;

    public EmpRefMappingPlugin(IPayrollPlugin plugin, String targetEmpRef) {
        super(plugin);
        this.targetEmpRef = targetEmpRef;
    }

    public EmpRefMappingPlugin(IPayrollPlugin plugin) {
        this(plugin, "951/EZ86460");
    }

    @Override
    public List<IPAYEMessage> retrievePAYEMessages(PayrollServerSpec payroll, FormType formType, int taxYear, ISenderDetails senderDetails, String empRef) throws PluginException, CancelException {
        List<IPAYEMessage> list = super.retrievePAYEMessages(payroll, formType, taxYear, senderDetails, this.targetEmpRef);
        ArrayList<IPAYEMessage> result = new ArrayList<IPAYEMessage>(list.size());
        for (IPAYEMessage original : list) {
            result.add((IPAYEMessage)new PAYETechnicalWrapper(new EmpRefMappingMessage(original, empRef).getProxy(IPAYEMessage.class)).getProxy());
        }
        return result;
    }

    @Override
    public void storeDPSMessage(PayrollServerSpec payroll, IDPSMessage message, boolean firstInRow) throws PluginException, CancelException {
        message = new EmpRefMappingMessage(message, this.targetEmpRef).getProxy(IDPSMessage.class);
        super.storeDPSMessage(payroll, message, firstInRow);
    }

    static class EmpRefMappingMessage
    extends AbstractMessageWrapper<IMailMessage> {
        String empRef;

        EmpRefMappingMessage(IMailMessage message, String empRef) {
            super(message, IMailMessage.class);
            this.empRef = empRef;
        }

        @Override
        public String getEmpRef() {
            return this.empRef;
        }

        @Override
        public String getStoreSpace() {
            return this.empRef;
        }

        @Override
        public byte[] getBytes() throws IOException {
            try {
                byte[] bytes = super.getBytes();
                String[] parts = this.empRef.split("/");
                String message = new String(bytes, "UTF-8");
                message = message.replaceAll("<Key Type=\"TaxOfficeNumber\">\\d+</Key>", "<Key Type=\"TaxOfficeNumber\">" + parts[0] + "</Key>").replaceAll("<Key Type=\"TaxOfficeReference\">[^<]+</Key>", "<Key Type=\"TaxOfficeReference\">" + parts[1] + "</Key>");
                return message.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

