/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.response.ErrorResponse;
import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IPAYEError;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.core.response.PAYEError;
import com.selima.fbi.loader.CombinedStream;
import com.selima.fbi.loader.ILoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;

public class SchematronResponseLoader
implements ILoader<IStorableResponse> {
    public static final String NS_FBI_VALIDATION = "http://selima.co.uk/fbi/validation";

    @Override
    public IStorableResponse load(InputStream stream) throws IOException {
        CombinedStream cstream = new CombinedStream(stream);
        List<IPAYEError> errors = SchematronResponseLoader.parseErrors(new StreamSource(cstream));
        return new ErrorResponse(errors, cstream.getBytes());
    }

    public static IErrorResponse parse(String xml) throws IOException {
        List<IPAYEError> errors = SchematronResponseLoader.parseErrors(new StreamSource(new StringReader(xml)));
        return new ErrorResponse(errors, xml.getBytes("UTF-8"));
    }

    private static List<IPAYEError> parseErrors(StreamSource source) throws IOException {
        try {
            XMLEvent evt;
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = inputFactory.createXMLEventReader(source);
            if (reader.peek().getEventType() == 7) {
                reader.nextEvent();
            }
            if (!SchematronResponseLoader.isStartElement(evt = reader.nextTag(), NS_FBI_VALIDATION, "ErrorResponse")) {
                throw new IOException("Unexpected content: " + evt);
            }
            LinkedList<IPAYEError> errors = new LinkedList<IPAYEError>();
            String raisedBy = null;
            String type = null;
            String location = null;
            String assertId = null;
            String contextXPath = null;
            LinkedList<String> texts = new LinkedList<String>();
            LinkedList<String> relXPaths = new LinkedList<String>();
            while (reader.hasNext()) {
                evt = reader.nextEvent();
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "RaisedBy")) {
                    raisedBy = SchematronResponseLoader.getElementText(reader);
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "Type")) {
                    type = SchematronResponseLoader.getElementText(reader);
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "Location")) {
                    location = SchematronResponseLoader.getElementText(reader);
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "Text")) {
                    texts.add(SchematronResponseLoader.getElementText(reader));
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "AssertId")) {
                    assertId = SchematronResponseLoader.getElementText(reader);
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "ContextXPath")) {
                    contextXPath = SchematronResponseLoader.getElementText(reader);
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "RelXPath")) {
                    relXPaths.add(SchematronResponseLoader.getElementText(reader));
                    continue;
                }
                if (evt.isEndElement() && evt.asEndElement().getName().equals(new QName(NS_FBI_VALIDATION, "Error"))) {
                    errors.add(new PAYEError(assertId, raisedBy, type, location, texts));
                    texts = new LinkedList();
                    relXPaths = new LinkedList();
                    contextXPath = null;
                    assertId = null;
                    location = null;
                    raisedBy = null;
                    type = null;
                    continue;
                }
                if (SchematronResponseLoader.isStartElement(evt, NS_FBI_VALIDATION, "Error") || evt.isCharacters() && evt.asCharacters().getData().trim().length() == 0 || evt.isEndElement() || evt.isEndDocument()) continue;
                throw new IOException("Unexpected content: " + evt);
            }
            return errors;
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        catch (XMLStreamException e) {
            if (e.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static boolean isStartElement(XMLEvent evt, String ns, String name) {
        return evt.isStartElement() && evt.asStartElement().getName().equals(new QName(ns, name));
    }

    private static String getElementText(XMLEventReader reader) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (reader.peek() != null && reader.peek().isCharacters()) {
            sb.append(reader.nextEvent().asCharacters().getData());
        }
        return sb.toString();
    }
}

