/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.response.ErrorResponse;
import com.selima.fbi.core.response.HMRCMarkReceipt;
import com.selima.fbi.core.response.IPAYEError;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.core.response.Message;
import com.selima.fbi.core.response.PAYEError;
import com.selima.fbi.core.response.SuccessResponse;
import com.selima.fbi.loader.CombinedStream;
import com.selima.fbi.loader.ILoader;
import com.selima.fbi.util.StringUtil;
import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class ResponseLoader
implements ILoader<IStorableResponse> {
    static final String SUCCESS_NS = "http://www.inlandrevenue.gov.uk/SuccessResponse";
    static final String ERROR_NS = "http://www.govtalk.gov.uk/CM/errorresponse";
    static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#";

    public IStorableResponse load(String body) throws IOException {
        String xml;
        String string = xml = body.startsWith("<?xml") ? body : "<?xml version='1.0'?>" + body;
        if (body.contains("ErrorResponse") && !body.contains("http://www.w3.org/2001/XMLSchema-instance")) {
            xml = xml.replaceFirst("xsi:schemaLocation=('[^']+'|\"[^\"]+\")", "");
        }
        return this.load(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    @Override
    public IStorableResponse load(InputStream inputStream) throws IOException {
        try {
            XMLEvent evt;
            CombinedStream stream = new CombinedStream(inputStream);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = inputFactory.createXMLEventReader(stream);
            if (reader.peek().getEventType() == 7) {
                reader.nextEvent();
            }
            if (this.isStartElement(evt = reader.nextTag(), SUCCESS_NS, "SuccessResponse")) {
                boolean testInLive = Boolean.parseBoolean(this.getAttribute(evt, "TestInLive"));
                Date acceptedTime = null;
                String irMark = null;
                String xmlSignature = null;
                LinkedList<Message> messages = new LinkedList<Message>();
                int startOfSignature = 0;
                int offset = 0;
                while (reader.hasNext()) {
                    evt = reader.nextEvent();
                    if (this.isStartElement(evt, SUCCESS_NS, "Message")) {
                        int code = Integer.parseInt(this.getAttribute(evt, "code"));
                        String text = this.getElementText(reader);
                        messages.add(new Message(code, text));
                    } else if (this.isStartElement(evt, SUCCESS_NS, "AcceptedTime")) {
                        try {
                            acceptedTime = StringUtil.parseXsdDateTime(this.getElementText(reader));
                        }
                        catch (ParseException e) {
                            LogAPI.logSevere((String)"Failed to parse AcceptedTime value from SuccessResponse", (Throwable)e);
                        }
                    } else if (this.isStartElement(evt, DSIG_NS, "DigestValue")) {
                        irMark = this.getElementText(reader);
                    } else if (this.isStartElement(evt, DSIG_NS, "Signature")) {
                        startOfSignature = offset;
                    } else if (this.isEndElement(evt, DSIG_NS, "Signature")) {
                        xmlSignature = new String(stream.getBytes(), startOfSignature, evt.getLocation().getCharacterOffset() - startOfSignature, "UTF-8");
                    }
                    offset = evt.getLocation().getCharacterOffset();
                }
                HMRCMarkReceipt receipt = null;
                if (irMark != null) {
                    receipt = new HMRCMarkReceipt(irMark, xmlSignature);
                }
                return new SuccessResponse(testInLive, acceptedTime, receipt, messages, stream.getBytes());
            }
            if (this.isStartElement(evt, ERROR_NS, "ErrorResponse")) {
                LinkedList<IPAYEError> errors = new LinkedList<IPAYEError>();
                String errorCode = null;
                String raisedBy = null;
                String type = null;
                String location = null;
                LinkedList<String> texts = new LinkedList<String>();
                while (reader.hasNext()) {
                    evt = reader.nextEvent();
                    if (this.isStartElement(evt, ERROR_NS, "RaisedBy")) {
                        raisedBy = this.getElementText(reader);
                        continue;
                    }
                    if (this.isStartElement(evt, ERROR_NS, "Type")) {
                        type = this.getElementText(reader);
                        continue;
                    }
                    if (this.isStartElement(evt, ERROR_NS, "Location")) {
                        location = this.getElementText(reader);
                        continue;
                    }
                    if (this.isStartElement(evt, ERROR_NS, "Text")) {
                        texts.add(this.getElementText(reader));
                        continue;
                    }
                    if (this.isStartElement(evt, ERROR_NS, "Number")) {
                        errorCode = this.getElementText(reader);
                        continue;
                    }
                    if (!evt.isEndElement() || !evt.asEndElement().getName().equals(new QName(ERROR_NS, "Error"))) continue;
                    errors.add(new PAYEError(errorCode, raisedBy, type, location, texts));
                    errorCode = null;
                    type = null;
                    raisedBy = null;
                    location = null;
                    texts = new LinkedList();
                }
                return new ErrorResponse(errors, stream.getBytes());
            }
            throw new IOException("Unexpected content: " + evt);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        catch (XMLStreamException e) {
            if (e.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private String getElementText(XMLEventReader reader) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (reader.peek() != null && reader.peek().isCharacters()) {
            sb.append(reader.nextEvent().asCharacters().getData());
        }
        return sb.toString();
    }

    private String getAttribute(XMLEvent evt, String name) {
        Attribute attribute = evt.asStartElement().getAttributeByName(new QName("", name));
        return attribute != null ? attribute.getValue() : null;
    }

    private boolean isStartElement(XMLEvent evt, String ns, String name) {
        return evt.isStartElement() && evt.asStartElement().getName().equals(new QName(ns, name));
    }

    private boolean isEndElement(XMLEvent evt, String ns, String name) {
        return evt.isEndElement() && evt.asEndElement().getName().equals(new QName(ns, name));
    }
}

