/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.eoy2012.EOY2012Message;
import com.selima.fbi.core.standard.eoy2012.P14Part2012Message;
import com.selima.fbi.core.standard.eoy2012.P35Part2012Message;
import com.selima.fbi.core.standard.generated.paye2012.IRenvelope;
import com.selima.fbi.loader.PAYEMessageFactory;

class PAYE2012MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    PAYE2012MessageFactory() {
    }

    @Override
    public IPAYEMessage create(IRenvelope envelope, byte[] bytes) {
        String submission = envelope.getEndOfYearReturn().getSubmissionType();
        if ("complete".equals(submission)) {
            return new EOY2012Message(envelope, bytes);
        }
        if ("P14Part".equals(submission)) {
            return new P14Part2012Message(envelope, bytes);
        }
        if ("P35Part".equals(submission)) {
            return new P35Part2012Message(envelope, bytes);
        }
        throw new IllegalStateException(submission);
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

