/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.eoy2007.EOY2007Message;
import com.selima.fbi.core.standard.eoy2007.P14Part2007Message;
import com.selima.fbi.core.standard.eoy2007.P35Part2007Message;
import com.selima.fbi.core.standard.generated.paye2007.IRenvelope;
import com.selima.fbi.loader.PAYEMessageFactory;

class PAYE2007MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    PAYE2007MessageFactory() {
    }

    @Override
    public IPAYEMessage create(IRenvelope envelope, byte[] bytes) {
        String submission = envelope.getEndOfYearReturn().getSubmissionType();
        if ("complete".equals(submission)) {
            return new EOY2007Message(envelope, bytes);
        }
        if ("P14Part".equals(submission)) {
            return new P14Part2007Message(envelope, bytes);
        }
        if ("P35Part".equals(submission)) {
            return new P35Part2007Message(envelope, bytes);
        }
        throw new IllegalStateException(submission);
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

