/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.eoy2006.EOY2006Message;
import com.selima.fbi.core.standard.eoy2006.P14Part2006Message;
import com.selima.fbi.core.standard.eoy2006.P35Part2006Message;
import com.selima.fbi.core.standard.generated.paye2006.IRenvelope;
import com.selima.fbi.loader.PAYEMessageFactory;

class PAYE2006MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    PAYE2006MessageFactory() {
    }

    @Override
    public IPAYEMessage create(IRenvelope obj, byte[] bytes) {
        IRenvelope envelope = obj;
        String submission = envelope.getEndOfYearReturn().getSubmissionType();
        if ("complete".equals(submission)) {
            return new EOY2006Message(envelope, bytes);
        }
        if ("P14Part".equals(submission)) {
            return new P14Part2006Message(envelope, bytes);
        }
        if ("P35Part".equals(submission)) {
            return new P35Part2006Message(envelope, bytes);
        }
        throw new IllegalStateException(submission);
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

