/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CombinedStream
extends FilterInputStream {
    ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);

    public CombinedStream(InputStream stream) {
        super(stream);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.bytes.write(b, off, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result > 0) {
            this.bytes.write(b, 0, result);
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result > 0) {
            this.bytes.write(result);
        }
        return result;
    }

    byte[] getBytes() {
        return this.bytes.toByteArray();
    }
}

