/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.loader.CombinedStream;
import com.selima.fbi.loader.ILoader;
import com.selima.fbi.storage.IStorable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractJAXBLoader<LoadedType extends IStorable>
implements ILoader<LoadedType> {
    protected Unmarshaller unmarshaller;
    protected Marshaller marshaller;

    public AbstractJAXBLoader(Class<?> ... classes) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classes);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.marshaller = jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract LoadedType create(Object var1, byte[] var2);

    public LoadedType load(String enc, String xml) throws IOException {
        return this.load(new ByteArrayInputStream(xml.getBytes(enc)));
    }

    @Override
    public LoadedType load(InputStream stream) throws IOException {
        try {
            CombinedStream byteStream = new CombinedStream(stream);
            Object result = this.unmarshaller.unmarshal((InputStream)byteStream);
            return this.create(result, byteStream.getBytes());
        }
        catch (Exception e) {
            Throwable tw = e;
            while (tw.getCause() != null) {
                tw = tw.getCause();
            }
            IOException ioe = new IOException();
            ioe.initCause(tw);
            throw ioe;
        }
    }

    public LoadedType load(Element value) throws IOException {
        try {
            Object result = this.unmarshaller.unmarshal((Node)value);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(4096);
            this.marshaller.marshal(result, (OutputStream)byteStream);
            return this.create(result, byteStream.toByteArray());
        }
        catch (Exception e) {
            Throwable tw = e;
            while (tw.getCause() != null) {
                tw = tw.getCause();
            }
            IOException ioe = new IOException();
            ioe.initCause(tw);
            throw ioe;
        }
    }
}

