/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.hmrcMark;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.crypto.Base64;
import com.selima.fbi.hmrcMark.HMRCMarkCertificateException;
import com.selima.fbi.hmrcMark.HMRCMarkException;
import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.c14n.Canonicalizer;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HMRCMark {
    private static String SECURITY_WARNING = "<p>Hopefully this is just technical problem either in this program or at HMRC but a security breach is also possible.<p>Please contact technical support.";
    private static KeyStore trustedCertificates;
    private static XMLInputFactory xmlInputFactory;
    private static DocumentBuilderFactory domFactory;

    public static String createFrom(byte[] bytes) throws HMRCMarkException {
        try {
            byte[] prolog = "<Body xmlns=\"http://www.govtalk.gov.uk/CM/envelope\">".getBytes("UTF-8");
            byte[] epilog = "</Body>".getBytes("UTF-8");
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            byte[] xmlFragment = canonicalizer.canonicalize(HMRCMark.concat(prolog, bytes, epilog));
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] hashBytes = messageDigest.digest(xmlFragment);
            return Base64.encodeBytes(hashBytes);
        }
        catch (Exception e) {
            throw new HMRCMarkException("Failed to compute HMRC Mark", e);
        }
    }

    public static String hmrcMarkFrom(byte[] bytes) {
        return HMRCMark.hmrcMarkFrom(new ByteArrayInputStream(bytes));
    }

    public static String hmrcMarkFrom(InputStream bytes) {
        try {
            XMLStreamReader reader = HMRCMark.xmlInputFactory().createXMLStreamReader(bytes, "UTF-8");
            do {
                reader.next();
            } while (reader.hasNext() && (!reader.isStartElement() || !"IRmark".equals(reader.getName().getLocalPart())));
            return reader.hasNext() ? reader.getElementText() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] stripFrom(byte[] bytes) throws HMRCMarkException {
        try {
            XMLStreamReader reader = HMRCMark.xmlInputFactory().createXMLStreamReader(new ByteArrayInputStream(bytes), "UTF-8");
            while (!(!reader.hasNext() || reader.isStartElement() && "IRmark".equals(reader.getName().getLocalPart()))) {
                reader.next();
            }
            if (reader.hasNext()) {
                int start = HMRCMark.lastIndexOf("<IRmark".getBytes(), bytes, reader.getLocation().getCharacterOffset());
                do {
                    reader.next();
                } while (reader.hasNext() && !reader.isEndElement());
                int end = HMRCMark.lastIndexOf("</IRmark>".getBytes("UTF-8"), bytes, reader.getLocation().getCharacterOffset()) + "</IRmark>".length();
                byte[] result = new byte[bytes.length - (end - start)];
                System.arraycopy(bytes, 0, result, 0, start);
                System.arraycopy(bytes, end, result, start, bytes.length - end);
                return result;
            }
            return bytes;
        }
        catch (Exception e) {
            throw new HMRCMarkException("Failed to remove HMRC mark", e);
        }
    }

    public static byte[] addInto(byte[] bytes, String hmrcMark) throws HMRCMarkException {
        try {
            XMLStreamReader reader = HMRCMark.xmlInputFactory().createXMLStreamReader(new ByteArrayInputStream(bytes), "UTF-8");
            int insertionPoint = -1;
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement() && "Sender".equals(reader.getName().getLocalPart())) {
                    insertionPoint = HMRCMark.lastIndexOf("<Sender".getBytes("UTF-8"), bytes, reader.getLocation().getCharacterOffset());
                    break;
                }
                if (!reader.isEndElement() || !"IRheader".equals(reader.getName().getLocalPart())) continue;
                insertionPoint = HMRCMark.lastIndexOf("</IRheader".getBytes("UTF-8"), bytes, reader.getLocation().getCharacterOffset());
                break;
            }
            if (!reader.hasNext()) {
                throw new IllegalArgumentException(new String(bytes, "UTF-8"));
            }
            byte[] inclusion = ("<IRmark Type='generic'>" + hmrcMark + "</IRmark>").getBytes("UTF-8");
            byte[] extendedResult = new byte[bytes.length + inclusion.length];
            System.arraycopy(bytes, 0, extendedResult, 0, insertionPoint);
            System.arraycopy(inclusion, 0, extendedResult, insertionPoint, inclusion.length);
            System.arraycopy(bytes, insertionPoint, extendedResult, insertionPoint + inclusion.length, bytes.length - insertionPoint);
            return extendedResult;
        }
        catch (Exception e) {
            throw new HMRCMarkException("Failed to insert HMRC mark", e);
        }
    }

    private static int lastIndexOf(byte[] substring, byte[] string, int offset) {
        block0: for (int i = offset - 1; i >= 0; --i) {
            int j = i;
            for (int k = substring.length - 1; k >= 0; --k) {
                if (string[j] != substring[k]) continue block0;
                --j;
            }
            return i - substring.length + 1;
        }
        throw new IllegalArgumentException(new String(substring) + " not present in " + new String(string, 0, offset));
    }

    public static Document prepareIRmarkReceipt(final InputStream inputStream) throws HMRCMarkException {
        try {
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
            SignatureMethod sm = fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
            DigestMethod digestMethod = fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            XPathFilterParameterSpec transformSpec = new XPathFilterParameterSpec("(count(ancestor-or-self::node()|/gti:GovTalkMessage/gti:Body)=count(ancestor-or-self::node()))and(count(ancestor-or-self::node()|/gti:GovTalkMessage/gti:Body/*[name()='IRenvelope']/*[name()='IRheader']/*[name()='IRmark'])!=count(ancestor-or-self::node()))", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("gti", "http://www.govtalk.gov.uk/CM/envelope");
                }
            });
            Transform xpathTransform = fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", transformSpec);
            Transform canonTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (TransformParameterSpec)null);
            Reference ref = fac.newReference(null, digestMethod, Arrays.asList(xpathTransform, canonTransform), null, null);
            SignedInfo signedInfo = fac.newSignedInfo(cm, sm, Collections.singletonList(ref));
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(MailServiceConfig.getResourceAsStream("fakecert.jks"), "password".toCharArray());
            KeyStore.PrivateKeyEntry privateEntry = (KeyStore.PrivateKeyEntry)ks.getEntry("selfkey", new KeyStore.PasswordProtection("password".toCharArray()));
            Document receiptDocument = HMRCMark.documentBuilderFactory().newDocumentBuilder().newDocument();
            receiptDocument.appendChild(receiptDocument.createElementNS("http://www.inlandrevenue.gov.uk/SuccessResponse", "IRmarkReceipt"));
            receiptDocument.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:auto-ns1", "http://www.govtalk.gov.uk/CM/envelope");
            receiptDocument.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            DOMSignContext signContext = new DOMSignContext(privateEntry.getPrivateKey(), (Node)receiptDocument.getDocumentElement());
            signContext.setURIDereferencer(new URIDereferencer(){

                @Override
                public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
                    try {
                        Document requestDocument = HMRCMark.documentBuilderFactory().newDocumentBuilder().parse(new InputSource(inputStream));
                        return new DOMSubTreeData(requestDocument, false);
                    }
                    catch (SAXException e) {
                        throw new URIReferenceException(e);
                    }
                    catch (IOException e) {
                        throw new URIReferenceException(e);
                    }
                    catch (ParserConfigurationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
            KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance();
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Arrays.asList(keyInfoFactory.newX509Data(Arrays.asList(privateEntry.getCertificate()))));
            XMLSignature signature = fac.newXMLSignature(signedInfo, keyInfo);
            signature.sign(signContext);
            return receiptDocument;
        }
        catch (Exception e) {
            throw new HMRCMarkException("Failed to create IRmarkReceipt (HMRC mark)", e);
        }
    }

    public static String addIRmarkReceipt(Document receiptDocument, String responseBody) throws SAXException, IOException {
        try {
            DocumentBuilder domBuilder = HMRCMark.documentBuilderFactory().newDocumentBuilder();
            Document doc = domBuilder.parse(new InputSource(new StringReader(responseBody)));
            Element irMarkReceipt = receiptDocument.getDocumentElement();
            NodeList nodeList = doc.getElementsByTagNameNS(irMarkReceipt.getNamespaceURI(), irMarkReceipt.getLocalName());
            if (nodeList.getLength() > 0) {
                Node originalReceipt = nodeList.item(0);
                originalReceipt.getParentNode().removeChild(originalReceipt);
                NodeList children = originalReceipt.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if ("Signature".equals(child.getLocalName())) continue;
                    irMarkReceipt.appendChild(receiptDocument.importNode(child, true));
                }
            }
            doc.getDocumentElement().insertBefore(doc.importNode(irMarkReceipt, true), doc.getDocumentElement().getFirstChild());
            return HMRCMark.toXMLString(doc);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toXMLString(Document doc) {
        try {
            StringWriter stringWriter = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(doc), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Node xmlSignatureOf(InputStream responseStream) throws HMRCMarkException {
        try {
            DocumentBuilder documentBuilder = HMRCMark.documentBuilderFactory().newDocumentBuilder();
            Document successResponse = documentBuilder.parse(responseStream);
            NodeList nodeList = successResponse.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nodeList.getLength() > 0) {
                return nodeList.item(0);
            }
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new HMRCMarkException("Failed to parse HMRC response while searching for XML-signature", e);
        }
        catch (SAXException e) {
            throw new HMRCMarkException("Failed to parse HMRC response while searching for XML-signature", e);
        }
    }

    public static void checkXMLSignature(final InputStream requestStream, Node signatureNode) throws HMRCMarkException {
        CertificateSelector certificateSelector = new CertificateSelector();
        DOMValidateContext validationContext = new DOMValidateContext(certificateSelector, signatureNode);
        validationContext.setURIDereferencer(new URIDereferencer(){

            @Override
            public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
                try {
                    DocumentBuilder documentBuilder = HMRCMark.documentBuilderFactory().newDocumentBuilder();
                    Document originalRequest = documentBuilder.parse(requestStream);
                    return new DOMSubTreeData(originalRequest, false);
                }
                catch (ParserConfigurationException e) {
                    throw new URIReferenceException(e);
                }
                catch (SAXException e) {
                    throw new URIReferenceException(e);
                }
                catch (IOException e) {
                    throw new URIReferenceException(e);
                }
            }
        });
        try {
            XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
            XMLSignature signature = signatureFactory.unmarshalXMLSignature(validationContext);
            if (!signature.getSignatureValue().validate(validationContext)) {
                throw new HMRCMarkException("The XML-Signature of the HMRC response is invalid." + SECURITY_WARNING);
            }
            Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
            int j = 0;
            while (i.hasNext()) {
                if (!i.next().validate(validationContext)) {
                    throw new HMRCMarkException("The XML-Signature of the response is invalid. Submission digest contained is not the one of our submission." + SECURITY_WARNING);
                }
                ++j;
            }
        }
        catch (MarshalException e) {
            throw new HMRCMarkException("Unexpected failure while verifying XML-signature of the HMRC response", e);
        }
        catch (XMLSignatureException e) {
            if (certificateSelector.triedAndFailed) {
                if (certificateSelector.certificate != null) {
                    throw new HMRCMarkCertificateException("The HMRC response is signed by certificate we do not trust." + SECURITY_WARNING, certificateSelector.certificate);
                }
                throw new HMRCMarkException("The XML-Signature of the response can not be verified. It lacks signing security certificate to check against." + SECURITY_WARNING);
            }
            throw new HMRCMarkException("Unexpected failure while verifying XML-signature of the HMRC response", e);
        }
    }

    public static void setTrustedKeyStore(String keyStoreResource, String keyStorePassword) {
        try {
            trustedCertificates = KeyStore.getInstance("JKS");
            trustedCertificates.load(MailServiceConfig.getResourceAsStream(keyStoreResource), keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    private static byte[] concat(byte[] ... arrays) {
        int size = 0;
        for (byte[] bytes : arrays) {
            size += bytes.length;
        }
        byte[] result = new byte[size];
        int pos = 0;
        for (int i = 0; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, result, pos, arrays[i].length);
            pos += arrays[i].length;
        }
        return result;
    }

    private static XMLInputFactory xmlInputFactory() {
        if (xmlInputFactory == null) {
            xmlInputFactory = XMLInputFactory.newInstance();
        }
        return xmlInputFactory;
    }

    private static DocumentBuilderFactory documentBuilderFactory() {
        if (domFactory == null) {
            domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
        }
        return domFactory;
    }

    private static final class CertificateSelector
    extends KeySelector {
        X509Certificate certificate;
        TrustManagerFactory tmf;
        boolean triedAndFailed;

        CertificateSelector() throws HMRCMarkException {
            try {
                this.tmf = TrustManagerFactory.getInstance("SunX509");
                this.tmf.init(trustedCertificates);
            }
            catch (Exception e) {
                throw new HMRCMarkException("Failed to setup KeyStore infrastructure necessary to validate HMRC security certificate", e);
            }
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure object : keyInfo.getContent()) {
                if (!(object instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)object;
                for (Object item : x509Data.getContent()) {
                    if (!(item instanceof X509Certificate)) continue;
                    this.certificate = (X509Certificate)item;
                    for (TrustManager tm : this.tmf.getTrustManagers()) {
                        try {
                            X509TrustManager xtm = (X509TrustManager)tm;
                            xtm.checkServerTrusted(new X509Certificate[]{this.certificate}, "RSA");
                            return new KeySelectorResult(){

                                @Override
                                public Key getKey() {
                                    return certificate.getPublicKey();
                                }
                            };
                        }
                        catch (CertificateException e) {
                        }
                    }
                }
            }
            this.triedAndFailed = true;
            throw new KeySelectorException();
        }
    }
}

