/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.gotvalue;

import com.selima.fbi.CancelException;
import com.selima.fbi.gotvalue.GotValueImpl;
import com.selima.fbi.gotvalue.IGotValueManager;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.memory.InMemoryStorage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GotValueManager
implements IGotValueManager {
    String alias;
    IStorageFactory storageFactory;
    Map<String, IStorage<GotValueImpl>> caches = new HashMap<String, IStorage<GotValueImpl>>();

    public GotValueManager(IStorageFactory storageFactory) {
        this("got", storageFactory);
    }

    public GotValueManager(String alias, IStorageFactory storageFactory) {
        this.alias = alias;
        this.storageFactory = storageFactory;
    }

    @Override
    public long getGotValue(String employer, String type) throws IOException, CancelException {
        IStorage<GotValueImpl> cache = this.getCache(employer);
        if (cache.contains(type)) {
            return cache.load(type).getGot();
        }
        IStorage<GotValueImpl> storage = this.getStorage(employer);
        if (storage.contains(type)) {
            GotValueImpl value = storage.load(type);
            cache.store(value);
            return value.getGot();
        }
        return 0L;
    }

    @Override
    public void setGotValue(String employer, String type, long value) throws IOException, CancelException {
        this.getCache(employer).store(new GotValueImpl(type, employer, value));
    }

    @Override
    public void beginTransaction() {
        assert (this.caches.isEmpty());
    }

    @Override
    public void commitTransaction() throws IOException, CancelException {
        for (Map.Entry<String, IStorage<GotValueImpl>> entry : this.caches.entrySet()) {
            IStorage<GotValueImpl> storage = this.getStorage(entry.getKey());
            IStorage<GotValueImpl> cache = entry.getValue();
            for (String type : cache.getIds()) {
                storage.store(cache.load(type));
            }
        }
        this.caches.clear();
    }

    @Override
    public void rollbackTransaction() {
        this.caches.clear();
    }

    IStorage<GotValueImpl> getCache(String employer) {
        IStorage<GotValueImpl> result = this.caches.get(employer);
        if (result == null) {
            result = new InMemoryStorage<GotValueImpl>(GotValueImpl.class);
            this.caches.put(employer, result);
        }
        return result;
    }

    IStorage<GotValueImpl> getStorage(String employer) throws IOException, CancelException {
        return this.storageFactory.getStorage(this.alias, employer, GotValueImpl.class);
    }
}

