/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.Buffer;
import com.selima.fbi.crypto.IBytesTransformation;
import com.selima.fbi.crypto.TransformingBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class TransformingOutputStream
extends OutputStream {
    OutputStream wrappedStream;
    Buffer decodedBuffer;
    TransformingBuffer encodedBuffer;

    public TransformingOutputStream(OutputStream outputStream, IBytesTransformation transformation) {
        this.wrappedStream = outputStream;
        this.decodedBuffer = new Buffer();
        this.encodedBuffer = new TransformingBuffer(transformation);
    }

    @Override
    public void write(int b) throws IOException {
        while (this.decodedBuffer.canFeed() == 0) {
            if (this.encodedBuffer.feedFrom(this.decodedBuffer)) continue;
            this.encodedBuffer.giveTo(this.wrappedStream);
        }
        this.decodedBuffer.feedByte(b);
    }

    @Override
    public void close() throws IOException {
        if (this.wrappedStream != null) {
            this.encodedBuffer.giveTo(this.wrappedStream);
            this.encodedBuffer.feedLastBitsFrom(this.decodedBuffer);
            this.encodedBuffer.giveTo(this.wrappedStream);
            assert (this.encodedBuffer.canGive() == 0 && this.decodedBuffer.canGive() == 0);
            this.wrappedStream.close();
            this.encodedBuffer = null;
            this.decodedBuffer = null;
            this.wrappedStream = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.encodedBuffer.giveTo(this.wrappedStream);
        this.encodedBuffer.feedFrom(this.decodedBuffer);
        this.encodedBuffer.giveTo(this.wrappedStream);
        this.wrappedStream.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    private void write(ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            this.decodedBuffer.feedFrom(buffer);
            while (this.decodedBuffer.canFeed() == 0) {
                if (this.encodedBuffer.feedFrom(this.decodedBuffer)) continue;
                this.encodedBuffer.giveTo(this.wrappedStream);
            }
        }
    }
}

